% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/events.R
\name{periods}
\alias{periods}
\title{Get a dataframe of sleep periods from a hypnogram, continuous or by stages.}
\usage{
periods(
  hypnogram,
  mode = "continuous",
  stages = c("N1", "N2", "N3", "N4", "REM")
)
}
\arguments{
\item{hypnogram}{A hypnogram dataframe. Dataframe must contain \code{begin} (\code{POSIXt}), \code{end} (\code{POSIXt}) and \code{event} (\code{character}) columns.}

\item{mode}{Period mode. \code{"continuous"} computes periods of N1, N2, N3 or REM sleep, regardless of stage. \code{"stages"} computes periods of sleep by stage.}

\item{stages}{Stages to include in periods. Defaults to `c("N1", "N2", "N3", "N4", "REM")`.}
}
\value{
A dataframe of periods with their begin and stop times, duration and stages for stage mode.
}
\description{
Get a dataframe of sleep periods from a hypnogram, continuous or by stages.
}
\examples{
library(ggplot2)

download.file(
 "https://rsleep.org/data/hypnodensity.csv",
 "hypnodensity.csv")

hypnodensity <- read.csv2("hypnodensity.csv")

unlink("hypnodensity.csv")

events <- hypnogram(hypnodensity)

periods_continuous <- periods(events, mode = "continuous")

ggplot(periods_continuous, aes(x=duration)) + geom_histogram(bins = 30)

periods_stages <- periods(events, mode = "stages")
 
ggplot(periods_stages, aes(x=event,y=duration,color=event)) + geom_boxplot()
}
