% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stan_gamm4.R
\name{stan_gamm4}
\alias{plot_nonlinear}
\alias{stan_gamm4}
\title{Bayesian generalized linear additive models with optional group-specific
terms via Stan}
\usage{
stan_gamm4(formula, random = NULL, family = gaussian(), data,
  weights = NULL, subset = NULL, na.action, knots = NULL,
  drop.unused.levels = TRUE, ..., prior = normal(),
  prior_intercept = normal(), prior_smooth = exponential(autoscale = FALSE),
  prior_aux = exponential(), prior_covariance = decov(), prior_PD = FALSE,
  algorithm = c("sampling", "meanfield", "fullrank"), adapt_delta = NULL,
  QR = FALSE, sparse = FALSE)

plot_nonlinear(x, smooths, ..., prob = 0.9, facet_args = list(),
  alpha = 1, size = 0.75)
}
\arguments{
\item{formula, random, family, data, knots, drop.unused.levels}{Same as for 
\code{\link[gamm4]{gamm4}}. \emph{We strongly advise against
omitting the \code{data} argument}. Unless \code{data} is specified (and is
a data frame) many post-estimation functions (including \code{update},
\code{loo}, \code{kfold}) are not guaranteed to work properly.}

\item{subset, weights, na.action}{Same as \code{\link[stats]{glm}}, 
but rarely specified.}

\item{...}{Further arguments passed to \code{\link[rstan]{sampling}} (e.g. 
\code{iter}, \code{chains}, \code{cores}, etc.) or to
\code{\link[rstan]{vb}} (if \code{algorithm} is \code{"meanfield"} or
\code{"fullrank"}).}

\item{prior}{The prior distribution for the regression coefficients. 
\code{prior} should be a call to one of the various functions provided by 
\pkg{rstanarm} for specifying priors. The subset of these functions that 
can be used for the prior on the coefficients can be grouped into several 
"families":

\tabular{ll}{
  \strong{Family} \tab \strong{Functions} \cr 
  \emph{Student t family} \tab \code{normal}, \code{student_t}, \code{cauchy} \cr 
  \emph{Hierarchical shrinkage family} \tab \code{hs}, \code{hs_plus} \cr 
  \emph{Laplace family} \tab \code{laplace}, \code{lasso} \cr
  \emph{Product normal family} \tab \code{product_normal} \cr
}

See the \link[=priors]{priors help page} for details on the families and 
how to specify the arguments for all of the functions in the table above.
To omit a prior ---i.e., to use a flat (improper) uniform prior---
\code{prior} can be set to \code{NULL}, although this is rarely a good
idea.

\strong{Note:} Unless \code{QR=TRUE}, if \code{prior} is from the Student t
family or Laplace family, and if the \code{autoscale} argument to the 
function used to specify the prior (e.g. \code{\link{normal}}) is left at 
its default and recommended value of \code{TRUE}, then the default or 
user-specified prior scale(s) may be adjusted internally based on the
scales of the predictors. See the \link[=priors]{priors help page} and the
\emph{Prior Distributions} vignette for details on the rescaling and the
\code{\link{prior_summary}} function for a summary of the priors used for a
particular model.}

\item{prior_intercept}{The prior distribution for the intercept. 
\code{prior_intercept} can be a call to \code{normal}, \code{student_t} or 
\code{cauchy}. See the \link[=priors]{priors help page} for details on 
these functions. To omit a prior on the intercept ---i.e., to use a flat
(improper) uniform prior--- \code{prior_intercept} can be set to
\code{NULL}.

\strong{Note:} If using a dense representation of the design matrix 
---i.e., if the \code{sparse} argument is left at its default value of 
\code{FALSE}--- then the prior distribution for the intercept is set so it 
applies to the value \emph{when all predictors are centered}. If you prefer
to specify a prior on the intercept without the predictors being
auto-centered, then you have to omit the intercept from the
\code{\link[stats]{formula}} and include a column of ones as a predictor,
in which case some element of \code{prior} specifies the prior on it,
rather than \code{prior_intercept}.}

\item{prior_smooth}{The prior distribution for the hyperparameters in GAMs,
with lower values yielding less flexible smooth functions.
 
\code{prior_smooth} can be a call to \code{exponential} to 
use an exponential distribution, or \code{normal}, \code{student_t} or 
\code{cauchy}, which results in a half-normal, half-t, or half-Cauchy 
prior. See \code{\link{priors}} for details on these functions. To omit a 
prior ---i.e., to use a flat (improper) uniform prior--- set 
\code{prior_smooth} to \code{NULL}. The number of hyperparameters depends
on the model specification but a scalar prior will be recylced as necessary
to the appropriate length.}

\item{prior_aux}{The prior distribution for the "auxiliary" parameter (if
applicable). The "auxiliary" parameter refers to a different parameter 
depending on the \code{family}. For Gaussian models \code{prior_aux} 
controls \code{"sigma"}, the error 
standard deviation. For negative binomial models \code{prior_aux} controls 
\code{"reciprocal_dispersion"}, which is similar to the 
\code{"size"} parameter of \code{\link[stats]{rnbinom}}:
smaller values of \code{"reciprocal_dispersion"} correspond to 
greater dispersion. For gamma models \code{prior_aux} sets the prior on 
to the \code{"shape"} parameter (see e.g., 
\code{\link[stats]{rgamma}}), and for inverse-Gaussian models it is the 
so-called \code{"lambda"} parameter (which is essentially the reciprocal of
a scale parameter). Binomial and Poisson models do not have auxiliary 
parameters. 

\code{prior_aux} can be a call to \code{exponential} to 
use an exponential distribution, or \code{normal}, \code{student_t} or 
\code{cauchy}, which results in a half-normal, half-t, or half-Cauchy 
prior. See \code{\link{priors}} for details on these functions. To omit a 
prior ---i.e., to use a flat (improper) uniform prior--- set 
\code{prior_aux} to \code{NULL}.}

\item{prior_covariance}{Cannot be \code{NULL}; see \code{\link{decov}} for
more information about the default arguments.}

\item{prior_PD}{A logical scalar (defaulting to \code{FALSE}) indicating
whether to draw from the prior predictive distribution instead of
conditioning on the outcome.}

\item{algorithm}{A string (possibly abbreviated) indicating the 
estimation approach to use. Can be \code{"sampling"} for MCMC (the
default), \code{"optimizing"} for optimization, \code{"meanfield"} for
variational inference with independent normal distributions, or
\code{"fullrank"} for variational inference with a multivariate normal
distribution. See \code{\link{rstanarm-package}} for more details on the
estimation algorithms. NOTE: not all fitting functions support all four
algorithms.}

\item{adapt_delta}{Only relevant if \code{algorithm="sampling"}. See 
\code{\link{adapt_delta}} for details.}

\item{QR}{A logical scalar defaulting to \code{FALSE}, but if \code{TRUE} 
applies a scaled \code{\link{qr}} decomposition to the design matrix, 
\eqn{X = Q^\ast R^\ast}{X = Q* R*}, where \eqn{Q^\ast = Q \sqrt{n-1}}{Q* = 
Q (n-1)^0.5} and \eqn{R^\ast = \frac{1}{\sqrt{n-1}} R}{R* = (n-1)^(-0.5) 
R}. The coefficients relative to \eqn{Q^\ast}{Q*} are obtained and then 
premultiplied by the inverse of \eqn{R^{\ast}}{R*} to obtain coefficients 
relative to the original predictors, \eqn{X}. These transformations do not 
change the likelihood of the data but are recommended for computational 
reasons when there are multiple predictors. Importantly, while the columns
of \eqn{X} are almost always correlated, the columns of \eqn{Q^\ast}{Q*}
are uncorrelated by design, which often makes sampling from the posterior
easier. However, because when \code{QR} is \code{TRUE} the \code{prior}
argument applies to the coefficients relative to \eqn{Q^\ast}{Q*} (and
those are not very interpretable), setting \code{QR=TRUE} is only
recommended if you do not have an informative prior for the regression
coefficients. 

For more details see the Stan case study 
\emph{The QR Decomposition For Regression Models} at 
\url{http://mc-stan.org/users/documentation/case-studies/qr_regression.html}.}

\item{sparse}{A logical scalar (defaulting to \code{FALSE}) indicating
whether to use a sparse representation of the design (X) matrix. 
If \code{TRUE}, the the design matrix is not centered (since that would 
destroy the sparsity) and likewise it is not possible to specify both 
\code{QR = TRUE} and \code{sparse = TRUE}. Depending on how many zeros
there are in the design matrix, setting \code{sparse = TRUE} may make
the code run faster and can consume much less RAM.}

\item{x}{An object produced by \code{stan_gamm4}.}

\item{smooths}{An optional character vector specifying a subset of the smooth
functions specified in the call to \code{stan_gamm4}. The default is
include all smooth terms.}

\item{prob}{For univarite smooths, a scalar between 0 and 1 governing the
width of the uncertainty interval.}

\item{facet_args}{An optional named list of arguments passed to 
\code{\link[ggplot2]{facet_wrap}} (other than the \code{facets} argument).}

\item{alpha, size}{For univariate smooths, passed to 
\code{\link[ggplot2]{geom_ribbon}}. For bivariate smooths, \code{size/2} is
passed to \code{\link[ggplot2]{geom_contour}}.}
}
\value{
A \link[=stanreg-objects]{stanreg} object is returned 
for \code{stan_gamm4}.

\code{plot_nonlinear} returns a ggplot object.
}
\description{
Bayesian inference for GAMMs with flexible priors.
}
\details{
The \code{stan_gamm4} function is similar in syntax to 
  \code{\link[gamm4]{gamm4}} in the \pkg{gamm4} package. But rather than performing 
  (restricted) maximum likelihood estimation with the \pkg{lme4} package,
  the \code{stan_gamm4} function utilizes MCMC to perform Bayesian 
  estimation. The Bayesian model adds priors on the common regression 
  coefficients (in the same way as \code{\link{stan_glm}}), priors on the 
  standard deviations of the smooth terms, and a prior on the decomposition
  of the covariance matrices of any group-specific parameters (as in 
  \code{\link{stan_glmer}}). Estimating these models via MCMC avoids
  the optimization issues that often crop up with GAMMs and provides better
  estimates for the uncertainty in the parameter estimates. 
  
  See \code{\link[gamm4]{gamm4}} for more information about the model
  specicification and \code{\link{priors}} for more information about the
  priors on the main coefficients. The \code{formula} should include at least
  one smooth term, which can be specified in any way that is supported by the
  \code{\link[mgcv]{jagam}} function in the \pkg{mgcv} package. The 
  \code{prior_smooth} argument should be used to specify a prior on the unknown
  standard deviations that govern how smooth the smooth function is. The
  \code{prior_covariance} argument can be used to specify the prior on the
  components of the covariance matrix for any (optional) group-specific terms.
  The \code{\link[gamm4]{gamm4}} function in the \pkg{gamm4} package uses
  group-specific terms to implement the departure from linearity in the smooth
  terms, but that is not the case for \code{stan_gamm4} where the group-specific
  terms are exactly the same as in \code{\link{stan_glmer}}.
  
  The \code{plot_nonlinear} function creates a ggplot object with one facet for
  each smooth function specified in the call to \code{stan_gamm4} in the case
  where all smooths are univariate. A subset of the smooth functions can be 
  specified using the \code{smooths} argument, which is necessary to plot a
  bivariate smooth or to exclude the bivariate smooth and plot the univariate
  ones. In the bivariate case, a plot is produced using 
  \code{\link[ggplot2]{geom_contour}}. In the univariate case, the resulting
  plot is conceptually similar to \code{\link[mgcv]{plot.gam}} except the 
  outer lines here demark the edges of posterior uncertainty intervals 
  (credible intervals) rather than confidence intervals and the inner line
  is the posterior median of the function rather than the function implied
  by a point estimate. To change the colors used in the plot see 
  \code{\link[bayesplot]{color_scheme_set}}.
}
\examples{
# from example(gamm4, package = "gamm4"), prefixing gamm4() call with stan_
\donttest{
dat <- mgcv::gamSim(1, n = 400, scale = 2) ## simulate 4 term additive truth
## Now add 20 level random effect `fac'...
dat$fac <- fac <- as.factor(sample(1:20, 400, replace = TRUE))
dat$y <- dat$y + model.matrix(~ fac - 1) \%*\% rnorm(20) * .5

br <- stan_gamm4(y ~ s(x0) + x1 + s(x2), data = dat, random = ~ (1 | fac), 
                 chains = 1, iter = 200) # for example speed
print(br)
plot_nonlinear(br)
plot_nonlinear(br, smooths = "s(x0)", alpha = 2/3)
}

}
\references{
Crainiceanu, C., Ruppert D., and Wand, M. (2005). Bayesian analysis for 
penalized spline regression using WinBUGS. \emph{Journal of Statistical
Software}. \strong{14}(14), 1--22. 
\url{https://www.jstatsoft.org/article/view/v014i14}
}
\seealso{
\code{\link{stanreg-methods}} and 
\code{\link[gamm4]{gamm4}}.

The vignette for \code{stan_glmer}, which also discusses
  \code{stan_gamm4}.
}

