% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_draws.R
\name{as_draws}
\alias{as_draws}
\alias{as_draws_list}
\alias{as_draws_array}
\alias{as_draws_df}
\alias{as_draws_matrix}
\alias{as_draws_rvars}
\alias{as_draws.stanemax}
\alias{as_draws.stanemaxbin}
\alias{as_draws_list.stanemax}
\alias{as_draws_list.stanemaxbin}
\alias{as_draws_array.stanemax}
\alias{as_draws_array.stanemaxbin}
\alias{as_draws_df.stanemax}
\alias{as_draws_df.stanemaxbin}
\alias{as_draws_matrix.stanemax}
\alias{as_draws_matrix.stanemaxbin}
\alias{as_draws_rvars.stanemax}
\alias{as_draws_rvars.stanemaxbin}
\title{Convert stanemax object to a posterior draws object}
\usage{
as_draws(x, ...)

as_draws_list(x, ...)

as_draws_array(x, ...)

as_draws_df(x, ...)

as_draws_matrix(x, ...)

as_draws_rvars(x, ...)

\method{as_draws}{stanemax}(x, inc_warmup = FALSE, ...)

\method{as_draws}{stanemaxbin}(x, inc_warmup = FALSE, ...)

\method{as_draws_list}{stanemax}(x, inc_warmup = FALSE, ...)

\method{as_draws_list}{stanemaxbin}(x, inc_warmup = FALSE, ...)

\method{as_draws_array}{stanemax}(x, inc_warmup = FALSE, ...)

\method{as_draws_array}{stanemaxbin}(x, inc_warmup = FALSE, ...)

\method{as_draws_df}{stanemax}(x, inc_warmup = FALSE, ...)

\method{as_draws_df}{stanemaxbin}(x, inc_warmup = FALSE, ...)

\method{as_draws_matrix}{stanemax}(x, inc_warmup = FALSE, ...)

\method{as_draws_matrix}{stanemaxbin}(x, inc_warmup = FALSE, ...)

\method{as_draws_rvars}{stanemax}(x, inc_warmup = FALSE, ...)

\method{as_draws_rvars}{stanemaxbin}(x, inc_warmup = FALSE, ...)
}
\arguments{
\item{x}{An object of class stanemax.}

\item{...}{Arguments passed to individual methods (if applicable).'}

\item{inc_warmup}{Should warmup draws be included? Defaults to \code{FALSE}.}
}
\value{
A draws object of the appropriate subclass
}
\description{
Convert stanemax object to a posterior draws object
}
\examples{
\dontrun{
data(exposure.response.sample)
fit <- stan_emax(response ~ exposure, exposure.response.sample)
posterior::as_draws_list(fit)
posterior::as_draws_array(fit)
posterior::as_draws_df(fit)
posterior::as_draws_matrix(fit)
posterior::as_draws_rvars(fit)
}
}
\seealso{
\code{\link[posterior:draws]{draws}}
\code{\link[posterior:subset_draws]{subset_draws}}
}
