% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/use_rstudio_prefs.R
\name{use_rstudio_prefs}
\alias{use_rstudio_prefs}
\title{Set RStudio Preferences}
\usage{
use_rstudio_prefs(..., .write_json = TRUE, .backup = TRUE)
}
\arguments{
\item{...}{series of RStudio preferences to update, e.g.
\verb{always_save_history = FALSE, rainbow_parentheses = TRUE}}

\item{.write_json}{logical indicating whether to update and overwrite
the existing JSON file of options. Default is \code{TRUE}. When \code{FALSE},
the function will return a list of all options, instead of writing
them to file.}

\item{.backup}{logical indicating whether to create a back-up of preferences
file before it's updated. Default is \code{TRUE}}
}
\value{
NULL, updates RStudio \code{rstudio-prefs.json} file
}
\description{
This function updates the RStudio preferences saved in
the \code{rstudio-prefs.json} file. A full listing of preferences that may be
modified are listed here
\url{https://docs.rstudio.com/ide/server-pro/session-user-settings.html}
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# pass preferences individually --------------
use_rstudio_prefs(
  always_save_history = FALSE,
  rainbow_parentheses = TRUE
)

# pass a list of preferences -----------------
pref_list <-
  list(always_save_history = FALSE,
       rainbow_parentheses = TRUE)

use_rstudio_prefs(!!!pref_list)
\dontshow{\}) # examplesIf}
}
\author{
Daniel D. Sjoberg
}
