% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/owner.R
\name{owner}
\alias{owner}
\alias{owner<-}
\alias{owner,character-method}
\alias{owner,SsimLibrary-method}
\alias{owner,Project-method}
\alias{owner,Scenario-method}
\alias{owner,Folder-method}
\alias{owner<-,character-method}
\alias{owner<-,SsimObject-method}
\alias{owner<-,Folder-method}
\title{Owner of a SsimLibrary, Project, Scenario, or Folder}
\usage{
owner(ssimObject)

owner(ssimObject) <- value

\S4method{owner}{character}(ssimObject)

\S4method{owner}{SsimLibrary}(ssimObject)

\S4method{owner}{Project}(ssimObject)

\S4method{owner}{Scenario}(ssimObject)

\S4method{owner}{Folder}(ssimObject)

\S4method{owner}{character}(ssimObject) <- value

\S4method{owner}{SsimObject}(ssimObject) <- value

\S4method{owner}{Folder}(ssimObject) <- value
}
\arguments{
\item{ssimObject}{\code{\link{Session}}, \code{\link{Project}},
\code{\link{SsimLibrary}}, or \code{\link{Folder}} object}

\item{value}{character string of the new owner}
}
\value{
A character string: the owner of the SsimObject.
}
\description{
Retrieves or sets the owner of a \code{\link{SsimLibrary}},
\code{\link{Project}}, \code{\link{Scenario}}, or \code{\link{Folder}}.
}
\examples{
\dontrun{
# Specify file path and name of new SsimLibrary
myLibraryName <- file.path(tempdir(), "testlib")

# Set up a SyncroSim Session, SsimLibrary, Project, and Scenario
mySession <- session()
myLibrary <- ssimLibrary(name = myLibraryName, session = mySession)
myProject <- project(myLibrary, project = "Definitions")
myScenario <- scenario(myProject, scenario = "My Scenario")

# Retrieve the owner of an SsimObject
owner(myLibrary)
owner(myProject)
owner(myScenario)

# Set the owner of a SyncroSim Scenario
owner(myScenario) <- "Apex RMS"
}

}
