% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chartCriteria.R
\name{chartCriteria}
\alias{chartCriteria}
\alias{chartCriteria,SsimObject-method}
\title{Retrieves chart variables}
\usage{
chartCriteria(ssimObject, chart = NULL, variable = NULL, filter = NULL)

\S4method{chartCriteria}{SsimObject}(ssimObject, chart = NULL, variable = NULL, filter = NULL)
}
\arguments{
\item{ssimObject}{\code{\link{Project}} or \code{\link{Chart}} object}

\item{chart}{character or integer. Either the name or ID of an existing chart.
If \code{NULL} and a \code{\link{Project}} is provided as the first argument,
then will return the available variables for charting.}

\item{variable}{character. The name of a charting variable. If provided,
then will return a list of the available filter columns for that variable.
Default is \code{NULL}.}

\item{filter}{character. The name of a filter column for a specified
variable. If provided, then will return a list of values that pertain to
the specified filter. If the filter column is used to disaggregate the
chart data (using the \code{\link{chartDisagg}} function), one panel will be
created for each of these values. If you would like to omit values from the
chart, you can also add or remove values by the specified filter column
using the \code{\link{chartInclude}} function. Default is \code{NULL}.}
}
\value{
A data.frame or list of variables, filter columns, and filter values.
}
\description{
Retrieves the available variables for charting, or the variables that are
set for an existing chart.
}
\details{
Example arguments:
\itemize{
\item If ssimObject is SyncroSim Project and chart is \code{NULL}: Returns
a data.frame of available variables for creating a new chart.
\item If ssimObject is SyncroSIm Chart or chart is not \code{NULL}: Returns
a data.frame of variables in use by the specified chart.
\item If variable is not \code{NULL}: Returns a list of filter columns
that belong to the given variable.
\item If variable and filter are not \code{NULL}: Returns a dataframe of
value IDs and names that belong to the given variable and filter.
}
}
\examples{
\dontrun{
# Create a chart object
myChart <- chart(myProject, chart = "New Chart")

# Retrieve variables that can be used to create new charts
chartCriteria(myProject)

# Retrieve variables being used by existing chart
chartCriteria(myChart)
}

}
