% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tt_dotabulation.R
\name{qtable_layout}
\alias{qtable_layout}
\alias{qtable}
\title{Generalized frequency table}
\usage{
qtable_layout(
  data,
  row_vars = character(),
  col_vars = character(),
  avar = NULL,
  row_labels = NULL,
  afun = NULL,
  summarize_groups = FALSE,
  title = "",
  subtitles = character(),
  main_footer = character(),
  prov_footer = character(),
  show_colcounts = TRUE,
  drop_levels = TRUE,
  ...,
  .default_rlabel = NULL
)

qtable(
  data,
  row_vars = character(),
  col_vars = character(),
  avar = NULL,
  row_labels = NULL,
  afun = NULL,
  summarize_groups = FALSE,
  title = "",
  subtitles = character(),
  main_footer = character(),
  prov_footer = character(),
  show_colcounts = TRUE,
  drop_levels = TRUE,
  ...
)
}
\arguments{
\item{data}{(\code{data.frame})\cr the data to tabulate.}

\item{row_vars}{(\code{character})\cr the names of variables to be used in row facetting.}

\item{col_vars}{(\code{character})\cr the names of variables to be used in column facetting.}

\item{avar}{(\code{string})\cr the variable to be analyzed. Defaults to the first variable in \code{data}.}

\item{row_labels}{(\code{character} or \code{NULL})\cr row label(s) which should be applied to the analysis rows. Length must
match the number of rows generated by \code{afun}.}

\item{afun}{(\code{function})\cr the function to generate the analysis row cell values. This can be a proper analysis
function, or a function which returns a vector or list. Vectors are taken as multi-valued single cells, whereas
lists are interpreted as multiple cells.}

\item{summarize_groups}{(\code{flag})\cr whether each level of nesting should include marginal summary rows. Defaults to
\code{FALSE}.}

\item{title}{(\code{string})\cr single string to use as main title (\code{\link[formatters:title_footer]{formatters::main_title()}}). Ignored for subtables.}

\item{subtitles}{(\code{character})\cr a vector of strings to use as subtitles (\code{\link[formatters:title_footer]{formatters::subtitles()}}), where every element is
printed on a separate line. Ignored for subtables.}

\item{main_footer}{(\code{character})\cr a vector of strings to use as main global (non-referential) footer materials
(\code{\link[formatters:title_footer]{formatters::main_footer()}}), where every element is printed on a separate line.}

\item{prov_footer}{(\code{character})\cr a vector of strings to use as provenance-related global footer materials
(\code{\link[formatters:title_footer]{formatters::prov_footer()}}), where every element is printed on a separate line.}

\item{show_colcounts}{(\code{logical(1)})\cr Indicates whether the lowest level of
applied to data. \code{NA}, the default, indicates that the \code{show_colcounts}
argument(s) passed to the relevant calls to \verb{split_cols_by*}
functions. Non-missing values will override the behavior specified in
column splitting layout instructions which create the lowest level, or
leaf, columns.}

\item{drop_levels}{(\code{flag})\cr whether unobserved factor levels should be dropped during facetting. Defaults to
\code{TRUE}.}

\item{...}{additional arguments passed to \code{afun}.}

\item{.default_rlabel}{(\code{string})\cr this is an implementation detail that should not be set by end users.}
}
\value{
\itemize{
\item \code{qtable} returns a built \code{TableTree} object representing the desired table
\item \code{qtable_layout} returns a \code{PreDataTableLayouts} object declaring the structure of the desired table, suitable for
passing to \code{\link[=build_table]{build_table()}}.
}
}
\description{
This function provides a convenience interface for generating generalizations of a 2-way frequency table. Row and
column space can be facetted by variables, and an analysis function can be specified. The function then builds a
layout with the specified layout and applies it to the data provided.
}
\details{
This function creates a table with a single top-level structure in both row and column dimensions involving faceting
by 0 or more variables in each dimension.

The display of the table depends on certain details of the tabulation. In the case of an \code{afun} which returns a
single cell's contents (either a scalar or a vector of 2 or 3 elements), the label rows for the deepest-nested row
facets will be hidden and the labels used there will be used as the analysis row labels. In the case of an \code{afun}
which returns a list (corresponding to multiple cells), the names of the list will be used as the analysis row
labels and the deepest-nested facet row labels will be visible.

The table will be annotated in the top-left area with an informative label displaying the analysis variable
(\code{avar}), if set, and the function used (captured via substitute) where possible, or 'count' if not. One exception
where the user may directly modify the top-left area (via \code{row_labels}) is the case of a table with row facets and
an \code{afun} which returns a single row.
}
\examples{
qtable(ex_adsl)
qtable(ex_adsl, row_vars = "ARM")
qtable(ex_adsl, col_vars = "ARM")
qtable(ex_adsl, row_vars = "SEX", col_vars = "ARM")
qtable(ex_adsl, row_vars = c("COUNTRY", "SEX"), col_vars = c("ARM", "STRATA1"))
qtable(ex_adsl,
  row_vars = c("COUNTRY", "SEX"),
  col_vars = c("ARM", "STRATA1"), avar = "AGE", afun = mean
)
summary_list <- function(x, ...) as.list(summary(x))
qtable(ex_adsl, row_vars = "SEX", col_vars = "ARM", avar = "AGE", afun = summary_list)
suppressWarnings(qtable(ex_adsl,
  row_vars = "SEX",
  col_vars = "ARM", avar = "AGE", afun = range
))

}
