% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_rt.R
\name{configure_rt_admm}
\alias{configure_rt_admm}
\title{Rt estimation algorithm configuration}
\usage{
configure_rt_admm(
  rho = -1,
  alpha = 0.5,
  gamma = 0.9,
  tolerance = 1e-04,
  maxiter_newton = 50L,
  maxiter_line = 20L,
  verbose = 0,
  ...
)
}
\arguments{
\item{rho}{Double. An ADMM parameter; coefficient of augmented term in the
Lagrangian function.}

\item{alpha}{Double. A parameter adjusting upper bound in line search algorithm
in \code{prox_newton} algorithm.}

\item{gamma}{Double. A parameter adjusting step size in line search algorithm
in \code{prox_newton} algorithm.}

\item{tolerance}{Double. Tolerance of ADMM convergence.}

\item{maxiter_newton}{Integer. Maximum number of iterations for the outer
Newton iteration.}

\item{maxiter_line}{Integer. Maximum number of iterations for the linesearch
algorithm in the proximal Newton method.}

\item{verbose}{Integer.}

\item{...}{space for future extensions}
}
\value{
a list of model parameters with class \code{rt_admm_configuration}
}
\description{
Rt estimation algorithm configuration
}
\examples{
configure_rt_admm()
configure_rt_admm(tolerance = 1e-6, verbose = 1L)
}
