% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{movmean}
\alias{movmean}
\alias{movmean2}
\alias{movmean_2d}
\title{movmean}
\usage{
movmean(y, halfwin = 1L, SG_style = FALSE, w = NULL)

movmean2(y, win_left = 1L, win_right = 0L, w = NULL)

movmean_2d(mat, win_left = 3L, win_right = 0L)
}
\arguments{
\item{y}{A numeric vector.}

\item{halfwin}{Integer, half of moving window size}

\item{SG_style}{If true, head and tail values will be in the style of SG
(more weights on the center point), else traditional moving mean style.}

\item{w}{Corresponding weights of y, with the same length.}

\item{win_left, win_right}{windows size in the left and right}

\item{mat}{numeric matrix}
}
\description{
NA and Inf values in the y will be ignored automatically.
}
\examples{
x <- 1:100
x[50] <- NA; x[80] <- Inf
s1 <- movmean(x, 2, SG_style = TRUE)
s2 <- movmean(x, 2, SG_style = FALSE)
movmean2(c(4, 8, 6, -1, -2, -3, -1), 2, 0)
movmean2(c(4, 8, NA, -1, -2, Inf, -1), 2, 0)
}
