% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_checks.R
\name{check_observations}
\alias{check_observations}
\alias{check_observations.character}
\alias{check_observations.data.frame}
\alias{check_observations.trimcommand}
\title{Check whether there are sufficient observations to run a model}
\usage{
check_observations(x, ...)

\method{check_observations}{data.frame}(x, model, covars = list(),
  changepoints = numeric(0), time.id = "time", count.id = "count",
  eps = 1e-08, ...)

\method{check_observations}{trimcommand}(x, ...)

\method{check_observations}{character}(x, ...)
}
\arguments{
\item{x}{A \code{\link{trimcommand}} object, a \code{data.frame}, or the location of a TRIM command file.}

\item{...}{Parameters passed to other methods.}

\item{model}{\code{[numeric]} Model 1, 2 or 3?}

\item{covars}{\code{[character|numeric]} column index of covariates in \code{x}}

\item{changepoints}{\code{[numeric]} Changepoints (model 2 only)}

\item{time.id}{\code{[character|numeric]} column index of time points in \code{x}}

\item{count.id}{\code{[character|numeric]} column index of the counts in \code{x}}

\item{eps}{\code{[numeric]} Numbers whose absolute magnitude are lesser than \code{eps} are considered zero.}
}
\value{
A \code{list} with two components. The component \code{sufficient} takes the value
\code{TRUE} or \code{FALSE} depending on whether sufficient counts have been found.
The component \code{errors} is a \code{list}, of which the structure depends on the chosen model,
that indicates under what conditions insufficient data is present to estimate the model.

\itemize{
\item{For model 3 without covariates, \code{$errors} is a list whose single element is a vector of time
points with insufficient counts}.
\item{For model 3 with covariates, \code{$errors} is a named list with an element for each covariate
for which insufficients counts are encountered. Each element is a two-column \code{data.frame}. The
first column indicates the time point, the second column indicates for which covariate value insufficient
counts are found.}
\item{For Model 2, without covariates \code{$errors} is a list with a single
element \code{changepoints}. It points out what changepoints lead to a time
slice with zero observations.}
\item{For Model 2, with covariates \code{$errors} is a named list with an
element for each covariate for which inssufficients counts are encountered.
Each element is a two-column \code{data.frame}, The first colum indicates the
changepoint, the second column indicates for which covariate value
insufficient counts are found.}
}
}
\description{
Check whether there are sufficient observations to run a model
}
\seealso{
Other modelspec: \code{\link{read_tcf}},
  \code{\link{read_tdf}}, \code{\link{set_trim_verbose}},
  \code{\link{trimcommand}}, \code{\link{trim}}
}

