% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statuses.R
\name{lookup_statuses}
\alias{lookup_statuses}
\alias{lookup_tweets}
\title{Get tweets data for given statuses (status IDs).}
\usage{
lookup_statuses(statuses, parse = TRUE, token = NULL)

lookup_tweets(statuses, parse = TRUE, token = NULL)
}
\arguments{
\item{statuses}{User id or screen name of target user.}

\item{parse}{Logical, indicating whether or not to parse
return object into data frame(s).}

\item{token}{OAuth token. By default \code{token = NULL} fetches a
non-exhausted token from an environment variable. Find
instructions on how to create tokens and setup an environment
variable in the tokens vignette (in r, send \code{?tokens} to
console).}
}
\value{
A tibble of tweets data.
}
\description{
Returns data on up to 90,000 Twitter statuses. To return data on
more than 90,000 statuses, users must iterate through status IDs
whilst avoiding rate limits, which reset every 15 minutes.
}
\examples{

\dontrun{

## create object containing status IDs
statuses <- c(
  "567053242429734913",
  "266031293945503744",
  "440322224407314432"
)

## lookup tweets data for given statuses
tw <- lookup_statuses(statuses)
tw

## view users data for these statuses via users_data()
users_data(tw)

}

}
\seealso{
\url{https://developer.twitter.com/en/docs/tweets/post-and-engage/api-reference/get-statuses-lookup}

Other tweets: \code{\link{get_favorites}},
  \code{\link{get_mentions}}, \code{\link{get_timeline}},
  \code{\link{lists_statuses}},
  \code{\link{search_tweets}}, \code{\link{tweets_data}},
  \code{\link{tweets_with_users}}
}
