% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/midas_functions.R
\name{DAGM_X_long_run_vol_no_skew}
\alias{DAGM_X_long_run_vol_no_skew}
\title{DAGM-X (daily) long-run volatility (no skewness)}
\usage{
DAGM_X_long_run_vol_no_skew(param, daily_ret, X, mv_m, K, lag_fun = "Beta")
}
\arguments{
\item{param}{Vector of estimated values. It must be a eight- or nine- dimensional vector. See the examples below.}

\item{daily_ret}{Daily returns, which must be an "xts" object.}

\item{X}{Additional "X" variable, which must be an "xts" object. Morever, "X" must be observed for the same days of daily_ret.}

\item{mv_m}{MIDAS variable already transformed into a matrix, through \code{\link{mv_into_mat}} function.}

\item{K}{Number of (lagged) realizations of the MIDAS variable to consider.}

\item{lag_fun}{\strong{optional}. Lag function to use. Valid choices are "Beta" (by default) and "Almon",
for the Beta and Exponential Almon lag functions, respectively.}
}
\value{
The resulting vector is an "xts" object representing the conditional volatility.
}
\description{
Obtains the daily long-run volatility for the DAGM-X.
For details, see \insertCite{amendola_candila_gallo:2019;textual}{rumidas}.
}
\examples{
# est_val<-c(0.01,0.80,0.05,0,0.1,1.1,-0.3,1.1)
# r_t<-sp500['/2010']
# X<-rv5['/2010']^0.5
# mv_m<-mv_into_mat(r_t,diff(indpro),K=12,"monthly")
# head(DAGM_X_long_run_vol_no_skew(est_val,r_t,X,mv_m,K=12))
}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{mv_into_mat}}.
}
\keyword{internal}
