% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{whicht_run}
\alias{whicht_run}
\title{Running which-true function}
\usage{
whicht_run(x, k = 0L, which = "last", na_rm = TRUE, na_pad = FALSE)
}
\arguments{
\item{x}{input logical vector where running which-true is calculated.}

\item{k}{Running window size. By default window size equals \code{length(x)}. Allow varying window size specified by vector of \code{length(x)}}

\item{which}{specifies whether \code{"first"} or \code{"last"} index is returned.}

\item{na_rm}{logical (default \code{na_rm=TRUE}) - if \code{TRUE} \code{NA} are replaced by last observed minimum prior to element.}

\item{na_pad}{logical (default \code{na_pad=FALSE}) - if \code{TRUE} first k-results will be filled by \code{NA}. If k is not specified na_pad=F by default.}
}
\value{
numeric vector of length equals length of \code{x} containing running index in \code{k}-long window.
}
\description{
\code{whicht_run} checks \code{which} element has value TRUE within specified running window.
}
\examples{
x <- c( NA, FALSE, TRUE, NA, TRUE, FALSE, TRUE, TRUE)
whicht_run( x, k=2, na_rm=TRUE, na_pad=FALSE )
}
