% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoencoder_variational.R, R/generics.R
\name{generate.ruta_autoencoder_variational}
\alias{generate.ruta_autoencoder_variational}
\alias{generate}
\title{Generate samples from a generative model}
\usage{
\method{generate}{ruta_autoencoder_variational}(
  learner,
  dimensions = c(1, 2),
  from = 0.05,
  to = 0.95,
  side = 10,
  fixed_values = 0.5,
  ...
)

generate(learner, ...)
}
\arguments{
\item{learner}{Trained learner object}

\item{dimensions}{Indices of the dimensions over which the model will be sampled}

\item{from}{Lower limit on the values which will be passed to the inverse CDF of the prior}

\item{to}{Upper limit on the values which will be passed to the inverse CDF of the prior}

\item{side}{Number of steps to take in each traversed dimension}

\item{fixed_values}{Value used as parameter for the inverse CDF of all non-traversed dimensions}

\item{...}{Unused}
}
\description{
Generate samples from a generative model
}
\seealso{
\verb{\link{autoencoder_variational}}
}
