% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dsvg.R
\name{dsvg}
\alias{dsvg}
\title{SVG Graphics Driver}
\usage{
dsvg(file = "Rplots.svg", width = 6, height = 6, bg = "white",
  pointsize = 12, standalone = TRUE, canvas_id = 1, fonts = list(),
  fontname_serif = NULL, fontname_sans = NULL, fontname_mono = NULL,
  fontname_symbol = NULL)
}
\arguments{
\item{file}{the file where output will appear.}

\item{height, width}{Height and width in inches.}

\item{bg}{Default background color for the plot (defaults to "white").}

\item{pointsize}{default point size.}

\item{standalone}{Produce a stand alone svg file? If \code{FALSE}, omits
xml header and default namespace.}

\item{canvas_id}{svg id within HTML page.}

\item{fonts}{Named list of font names to be aliased with
fonts installed on your system. If unspecified, the R default
families \code{sans}, \code{serif}, \code{mono} and \code{symbol}
are aliased to the family returned by \code{\link[gdtools]{match_family}()}.}

\item{fontname_serif, fontname_sans, fontname_mono, fontname_symbol}{font
names for font faces. Used fonts should be available in the operating system.
These arguments are deprecated in favor of the \code{fonts} argument.}
}
\description{
This function produces SVG files (compliant to the current w3 svg XML standard)
where elements can be made interactive.
}
\examples{
\donttest{
dsvg()
plot(rnorm(10), main="Simple Example", xlab = "", ylab = "")
dev.off()
}
}
\seealso{
\code{\link{Devices}}
}
\keyword{device}
