% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ph_with_vg.R
\name{ph_with_vg}
\alias{ph_with_vg}
\alias{ph_with_vg_at}
\title{add a plot output as vector graphics into a PowerPoint object}
\usage{
ph_with_vg(x, code, ggobj = NULL, type = "body", index = 1,
  location = NULL, ...)

ph_with_vg_at(x, code, ggobj = NULL, left, top, width, height, ...)
}
\arguments{
\item{x}{an \code{rpptx} object produced by \code{officer::read_pptx}}

\item{code}{plot instructions}

\item{ggobj}{ggplot objet to print. argument \code{code} will
be ignored if this argument is supplied.}

\item{type}{placeholder type}

\item{index}{placeholder index (integer). This is to be used when a placeholder type
is not unique in the current slide, e.g. two placeholders with type 'body'.}

\item{location}{a placeholder location object. This is a convenient
argument that can replace usage of arguments \code{type} and \code{index}.
See [ph_location_type], [ph_location], [ph_location_label],
[ph_location_left], [ph_location_right], [ph_location_fullsize].}

\item{...}{arguments passed on to \code{\link{dml_pptx}}.}

\item{left, top}{left and top origin of the plot on the slide in inches.}

\item{height, width}{Height and width in inches.}
}
\description{
produces a vector graphics output from R plot instructions
and add the result in a PowerPoint document object produced
by \code{\link[officer]{read_pptx}}. These functions will be deprecated
in the next release and function \code{\link{ph_with.dml}} should
be used instead.
}
\examples{
\donttest{
library(officer)
doc <- read_pptx()
doc <- add_slide(doc, "Title and Content", "Office Theme")
doc <- ph_with_vg(doc, code = barplot(1:5, col = 2:6), type = "body")
doc <- add_slide(doc, "Title and Content", "Office Theme")
doc <- ph_with_vg_at(doc, code = barplot(1:5, col = 2:6),
  left = 1, top = 2, width = 6, height = 4)
fileout <- tempfile(fileext = ".pptx")
# fileout <- "vg.pptx"
print(doc, target = fileout)
}
}
