% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/use_vignette_docker.R
\name{use_vignette_docker}
\alias{use_vignette_docker}
\title{Use vignette: Docker}
\usage{
use_vignette_docker(
  docker_org,
  title = "Docker/Singularity Containers",
  vignette_index_entry = "docker",
  save_dir = here::here(),
  path = file.path(save_dir, "vignettes", "docker.Rmd"),
  force_new = FALSE,
  show = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{docker_org}{DockerHub organization name. 
Can simply be your Dockerhub username instead.}

\item{title}{Title of vignette.}

\item{vignette_index_entry}{Index entry of the vignette, 
which is used when creating the navigation bar in the \pkg{pkgdown} site.}

\item{save_dir}{Directory to save the vignette file to.}

\item{path}{Path to the vignette file.}

\item{force_new}{If the file already exists, overwrite it 
(default: \code{FALSE}).}

\item{show}{Print the contents of the vignette file in the R console.}

\item{verbose}{Print messages.}
}
\value{
Path to vignette file.
}
\description{
Creates a vignette rmarkdown file demonstrates how to create a
 Docker/Singularity image from a container stored in 
\href{https://hub.docker.com/}{Dockerhub}.
}
\examples{
path <- use_vignette_docker(docker_org = "neurogenomicslab",
                            ## use default save_dir in practice
                            save_dir = tempdir())
}
