% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyze.rwty.R
\name{analyze.rwty}
\alias{analyze.rwty}
\title{analyze.rwty, the main interface for rwty analyses and plots.}
\usage{
analyze.rwty(chains, burnin = 0, window.size = 20, treespace.points = 100,
  n.clades = 20, min.freq = 0, fill.color = NA, filename = NA,
  overwrite = FALSE, facet = TRUE, free_y = FALSE,
  autocorr.intervals = 100, ess.reps = 20, treedist = "PD", params = NA,
  ...)
}
\arguments{
\item{chains}{A list of rwty.trees objects.}

\item{burnin}{The number of trees to eliminate as burnin.  Default value is zero.}

\item{window.size}{The number of trees to include in each windows of sliding window plots}

\item{treespace.points}{The number of trees to plot in the treespace plot. Default is 100}

\item{n.clades}{The number of clades to include in plots of split frequencies over the course of the MCMC}

\item{min.freq}{The minimum frequency for a node to be used for calculating ASDSF. Default is 0.1}

\item{fill.color}{The name of a column in your log file that you would like to use as the fill colour of points in the treespace plots}

\item{filename}{Name of an output file (e.g., "output.pdf").  If none is supplied, rwty will not save outputs to file.}

\item{overwrite}{Boolean variable saying whether output file should be overwritten, if it exists.}

\item{facet}{A Boolean expression indicating whether multiple chains should be plotted as facet plots (default TRUE).}

\item{free_y}{TRUE/FALSE to turn free y scales on the facetted plots on or off (default FALSE). Only works if facet = TRUE.}

\item{autocorr.intervals}{The maximum number of intervals to use for autocorrelation plots.}

\item{ess.reps}{The number of replicate analyses to do when calculating the pseudo ESS.}

\item{treedist}{the type of tree distance metric to use, can be 'PD' for path distance or 'RF' for Robinson Foulds distance.}

\item{params}{A vector of parameters to use when making the parameter correlation plots.  Defaults to the first two columns in the log table.}

\item{...}{Extra arguments to be passed to plotting and analysis functions.}
}
\value{
output The output is a list containing the following plots:

Plots of likelihood, model parameters, and tree topologies as a function of chain length (the first two only when output from MCMC parameters has been loaded along with the tree topologies).

Plot of autocorrelation of tree topolgies at different sampling intervals along a chain 

Plot of split frequencies calculated in sliding windows for the most variable clades

Plot of change in split frequencies between sliding windows for all clades

Plot of cumulative split frequencies as the MCMC progresses

Plot of change in cumulative split frequencies as the MCMC progresses

Heatmap and point depictions of chains in treespace.

Plot of the Average Standard Deviation of Split Frequencies (ASDSF) between chains as the MCMC progresses

Plot of pairwise correlations between split frequencies among chains  

Plot of chains clustered by their pairwise ASDSF values
}
\description{
This is the main user interface to rwty.  It allows users to conduct simple
visualizations of MCMC chain performance with  very few arguments.
}
\examples{
\dontrun{
data(fungus)
p <- analyze.rwty(fungus, burnin = 50, window.num = 50)
p
}
}
\keyword{ESS}
\keyword{MCMC,}
\keyword{plots,}
\keyword{rwty,}
\keyword{topology,}

