% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/piping-ini.R
\name{zeroRe}
\alias{zeroRe}
\title{Set random effects and residual error to zero}
\usage{
zeroRe(object, which = c("omega", "sigma"), fix = TRUE)
}
\arguments{
\item{object}{The model to modify}

\item{which}{The types of parameters to set to zero}

\item{fix}{Should the parameters be fixed to the zero value?}
}
\value{
The \code{object} with some parameters set to zero
}
\description{
Set random effects and residual error to zero
}
\examples{
one.compartment <- function() {
  ini({
    tka <- log(1.57); label("Ka")
    tcl <- log(2.72); label("Cl")
    tv <- log(31.5); label("V")
    eta.ka ~ 0.6
    eta.cl ~ 0.3
    eta.v ~ 0.1
    add.sd <- 0.7
  })
  model({
    ka <- exp(tka + eta.ka)
    cl <- exp(tcl + eta.cl)
    v <- exp(tv + eta.v)
    d/dt(depot) = -ka * depot
    d/dt(center) = ka * depot - cl / v * center
    cp = center / v
    cp ~ add(add.sd)
  })
}
zeroRe(one.compartment)
}
\seealso{
Other Initial conditions: 
\code{\link{ini.rxUi}()}
}
\author{
Bill Denney
}
\concept{Initial conditions}
