% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GSAT.R
\name{GSAT}
\alias{GSAT}
\title{Compute the Global Surface Air Temperature (GSAT) anomalies}
\usage{
GSAT(data, data_lats, data_lons, type, lat_dim = "lat", lon_dim = "lon",
  mask = NULL, monini = 11, fmonth_dim = "fmonth", sdate_dim = "sdate",
  indices_for_clim = NULL, year_dim = "year", month_dim = "month",
  member_dim = "member")
}
\arguments{
\item{data}{A numerical array to be used for the index computation with the 
dimensions: 1) latitude, longitude, start date, forecast month, and member 
(in case of decadal predictions), 2) latitude, longitude, year, month and 
member (in case of historical simulations), or 3) latitude, longitude, year
and month (in case of observations or reanalyses). This data has to be 
provided, at least, over the whole region needed to compute the index.}

\item{data_lats}{A numeric vector indicating the latitudes of the data.}

\item{data_lons}{A numeric vector indicating the longitudes of the data.}

\item{type}{A character string indicating the type of data ('dcpp' for 
decadal predictions, 'hist' for historical simulations, or 'obs' for 
observations or reanalyses).}

\item{lat_dim}{A character string of the name of the latitude dimension. The
default value is 'lat'.}

\item{lon_dim}{A character string of the name of the longitude dimension. The
default value is 'lon'.}

\item{mask}{An array of a mask (with 0's in the grid points that have to be 
masked) or NULL (i.e., no mask is used). This parameter allows to remove 
the values over land in case the dataset is a combination of surface air 
temperature over land and sea surface temperature over the ocean. Also, it
can be used to mask those grid points that are missing in the observational
dataset for a fair comparison between the forecast system and the reference
dataset. The default value is NULL.}

\item{monini}{An integer indicating the month in which the forecast system is
initialized. Only used when parameter 'type' is 'dcpp'. The default value 
is 11, i.e., initialized in November.}

\item{fmonth_dim}{A character string indicating the name of the forecast
month dimension. Only used if parameter 'type' is 'dcpp'. The default value
is 'fmonth'.}

\item{sdate_dim}{A character string indicating the name of the start date 
dimension. Only used if parameter 'type' is 'dcpp'. The default value is 
'sdate'.}

\item{indices_for_clim}{A numeric vector of the indices of the years to
compute the climatology for calculating the anomalies, or NULL so the 
climatology is calculated over the whole period. If the data are already 
anomalies, set it to FALSE. The default value is NULL.\cr
In case of parameter 'type' is 'dcpp', 'indices_for_clim' must be relative 
to the first forecast year, and the climatology is automatically computed 
over the actual common period for the different forecast years.}

\item{year_dim}{A character string indicating the name of the year dimension
The default value is 'year'. Only used if parameter 'type' is 'hist' or 
'obs'.}

\item{month_dim}{A character string indicating the name of the month
dimension. The default value is 'month'. Only used if parameter 'type' is 
'hist' or 'obs'.}

\item{member_dim}{A character string indicating the name of the member 
dimension. The default value is 'member'. Only used if parameter 'type' is
'dcpp' or 'hist'.}
}
\value{
A numerical array of the GSAT anomalies with the dimensions of:
 1) sdate, forecast year, and member (in case of decadal predictions);
 2) year and member (in case of historical simulations); or 
 3) year (in case of observations or reanalyses).
}
\description{
The Global Surface Air Temperature (GSAT) anomalies are computed as the 
weighted-averaged surface air temperature anomalies over the global region.
}
\examples{
## Observations or reanalyses
obs <- array(1:100, dim = c(year = 5, lat = 19, lon = 37, month = 12))
lat <- seq(-90, 90, 10)
lon <- seq(0, 360, 10)
index_obs <- GSAT(data = obs, data_lats = lat, data_lons = lon, type = 'obs')

## Historical simulations
hist <- array(1:100, dim = c(year = 5, lat = 19, lon = 37, month = 12, member = 5))
lat <- seq(-90, 90, 10)
lon <- seq(0, 360, 10)
index_hist <- GSAT(data = hist, data_lats = lat, data_lons = lon, type = 'hist')

## Decadal predictions
dcpp <- array(1:100, dim = c(sdate = 5, lat = 19, lon = 37, fmonth = 24, member = 5))
lat <- seq(-90, 90, 10)
lon <- seq(0, 360, 10)
index_dcpp <- GSAT(data = dcpp, data_lats = lat, data_lons = lon, type = 'dcpp', monini = 1)

}

