% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Histo2Hindcast.R
\name{Histo2Hindcast}
\alias{Histo2Hindcast}
\title{Chunk long simulations for comparison with hindcasts}
\usage{
Histo2Hindcast(
  data,
  sdatesin,
  sdatesout,
  nleadtimesout,
  sdate_dim = "sdate",
  ftime_dim = "ftime",
  ncores = NULL
)
}
\arguments{
\item{data}{A numeric array of model or observational data with dimensions
at least sdate_dim and ftime_dim.}

\item{sdatesin}{A character string of the start date of 'data'. The format
should be 'YYYYMMDD' or 'YYYYMM'.}

\item{sdatesout}{A vector of character string indicating the expected start 
dates of the output. The format should be 'YYYYMMDD' or 'YYYYMM'.}

\item{nleadtimesout}{A positive integer indicating the length of leadtimes of
the output.}

\item{sdate_dim}{A character string indicating the name of the sdate date 
dimension of 'data'. The default value is 'sdate'.}

\item{ftime_dim}{A character string indicating the name of the lead time 
dimension of 'data'. The default value is 'ftime'.}

\item{ncores}{An integer indicating the number of cores to use for parallel 
computation. The default value is NULL.}
}
\value{
A numeric array with the same dimensions as data, except the length
 of sdate_dim is 'sdatesout' and the length of ftime_dim is nleadtimesout.
}
\description{
Reorganize a long run (historical typically) with only one start date into 
chunks corresponding to a set of start dates. The time frequency of the data
should be monthly.
}
\examples{
 \dontshow{
startDates <- c('19901101')
sampleData <- s2dv:::.LoadSampleData('tos', c('experiment'),
                                    c('observation'), startDates,
                                    leadtimemin = 1,
                                    leadtimemax = 60,
                                    output = 'areave',
                                    latmin = 27, latmax = 48,
                                    lonmin = -12, lonmax = 40)
 }

sdates_out <- c('19901101', '19911101', '19921101', '19931101', '19941101')
leadtimes_per_startdate <- 12	
exp_data <- Histo2Hindcast(sampleData$mod, startDates, 
                          sdates_out, leadtimes_per_startdate)
obs_data <- Histo2Hindcast(sampleData$obs, startDates, 
                          sdates_out, leadtimes_per_startdate)
 \dontrun{
exp_data <- Reorder(exp_data, c(3, 4, 1, 2))
obs_data <- Reorder(obs_data, c(3, 4, 1, 2))
PlotAno(exp_data, obs_data, sdates_out, 
       toptitle = paste('Anomalies reorganized into shorter chunks'), 
       ytitle = 'K', fileout = NULL)
 }

}
