% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sNPLS_fit.R
\name{repeat_cv}
\alias{repeat_cv}
\title{Repeated cross-validation for sNPLS models}
\usage{
repeat_cv(X_npls, Y_npls, ncomp = 1:3, keepJ = 1:ncol(X_npls),
  keepK = 1:dim(X_npls)[3], nfold = 10, parallel = TRUE, free_cores = 2,
  times = 30)
}
\arguments{
\item{X_npls}{A three-way array containing the predictors.}

\item{Y_npls}{A matrix containing the response.}

\item{ncomp}{A vector with the different number of components to test}

\item{keepJ}{A vector with the different number of selected variables to test}

\item{keepK}{A vector with the different number of selected 'times' to test}

\item{nfold}{Number of folds for the cross-validation}

\item{parallel}{Should the computations be performed in parallel?}

\item{free_cores}{If parallel computations are performed how many cores are left unused}

\item{times}{Number of repetitions of the cross-validation}
}
\value{
A density plot with the results of the cross-validation
}
\description{
Performs repeated cross-validation and represents results in a plot
}

