% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vmeasure.R
\name{vmeasure}
\alias{vmeasure}
\title{V-measure}
\usage{
vmeasure(x, y, z = NULL, B = 1)
}
\arguments{
\item{x}{A numeric vector, representing a categorical values.}

\item{y}{A numeric vector, representing a categorical values.}

\item{z}{A numeric matrix. A contingency table of the counts at each
combination of categorical levels. By default this argument is set to \code{NULL},
and the value of \code{z} is calculated based on \code{x} and \code{y}.}

\item{B}{A numeric value. If \code{B} > 1 then completeness is weighted more strongly than
homogeneity, and if \code{B} < 1 then homogeneity is weighted more strongly than
completeness. By default this value is 1.}
}
\value{
A list with three elements:
\itemize{
\item "v_measure"
\item "homogeneity"
\item "completeness"
}
}
\description{
A conditional entropy-based external cluster evaluation measure.
}
\examples{
x = c(1, 1, 1, 2, 2, 3, 3, 3, 1, 1, 2, 2, 2, 3, 3)
y = c(rep(1, 5), rep(2, 5), rep(3, 5))
vmeasure(x, y)

}
\references{
Rosenberg, Andrew, and Julia Hirschberg. "V-measure:
A conditional entropy-based external cluster evaluation measure." Proceedings
of the 2007 joint conference on empirical methods in natural language
processing and computational natural language learning (EMNLP-CoNLL). 2007.
}
