% Generated by roxygen2 (4.0.2): do not edit by hand
\name{detect.fixations}
\alias{detect.fixations}
\title{Detect Fixations in a Stream of Raw Eye-Tracking Samples}
\usage{
detect.fixations(samples, lambda = 15, smooth.coordinates = T,
  smooth.saccades = T)
}
\arguments{
\item{samples}{a data frame containing the raw samples as recorded
by the eye-tracker.  This data frame has four columns:
\describe{
 \item{time:}{the time at which the sample was recorded}
 \item{trial:}{the trial to which the sample belongs}
 \item{x:}{the x-coordinate of the sample}
 \item{y:}{the y-coordinate of the sample}
}
Samples have to be listed in chronological order.  The velocity
calculations assume that the sampling frequency is constant.}

\item{lambda}{a parameter for tuning the saccade
detection.  It specifies which multiple of the standard deviation
of the velocity distribution should be used as the detection
threshold.}

\item{smooth.coordinates}{logical. If true the x- and y-coordinates will be
smoothed using a moving average with window size 3 prior to saccade
detection.}

\item{smooth.saccades}{logical.  If true, consecutive saccades that
are separated only by a few samples will be joined.  This avoids
the situation where swing-backs at the end of longer saccades are
recognized as separate saccades.  Whether this works well, depends
to some degree on the sampling rate of the eye-tracker.  If the
sampling rate is very high, the gaps between the main saccade and
the swing-back might become too large and look like genuine
fixations.  Likewise, if the sampling frequency is very low,
genuine fixations may be regarded as spurious.  Both cases are
unlikely to occur with current eye-trackers.}
}
\value{
a data frame containing the detected fixations.  This data
frame has the following columns:
 \item{trial}{the trial to which the fixation belongs}
 \item{start}{the time at which the fixation started}
 \item{end}{the time at which the fixation ended}
 \item{x}{the x-coordinate of the fixation}
 \item{y}{the y-coordinate of the fixation}
 \item{sd.x}{the standard deviation of the sample x-coordinates within the fixation}
 \item{sd.y}{the standard deviation of the sample y-coordinates within the fixation}
 \item{peak.vx}{the horizontal peak velocity that was reached within the fixation}
 \item{peak.vy}{the vertical peak velocity that was reached within the fixation}
 \item{dur}{the duration of the fixation}
}
\description{
Takes a data frame containing raw eye-tracking samples and returns a
data frame containing fixations.
}
\section{Details}{
 This function uses a velocity-based detection
algorithm for saccades proposed by Engbert and Kliegl.  Anything
between two saccades is considered to be a fixation.  Thus, the
algorithm is not suitable for data sets containing episodes of
smooth pursuit eye movements.
}
\examples{
data(samples)
head(samples)
fixations <- detect.fixations(samples)
head(fixations)
\dontrun{
first.trial <- samples$trial[1]
first.trial.samples <- subset(samples, trial==first.trial)
first.trial.fixations <- subset(fixations, trial==first.trial)
with(first.trial.samples, plot(x, y, pch=20, cex=0.2, col="red"))
with(first.trial.fixations, points(x, y, cex=1+sqrt(dur/10000)))
}
}
\author{
Titus von der Malsburg \email{malsburg@posteo.de}
}
\references{
Ralf Engbert, Reinhold Kliegl: Microsaccades uncover the
orientation of covert attention, Vision Research, 2003.
}
\seealso{
\code{\link{diagnostic.plot}},
\code{\link{calculate.summary}}
}
\keyword{classif}
\keyword{manip}
\keyword{ts}

