% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gpois.R
\name{GPois}
\alias{GPois}
\title{Small Area Estimation Using Hierarchical Bayesian Method under Generalized Poisson Distribution}
\usage{
GPois(
  formula,
  iter.update = 3,
  iter.mcmc = 2000,
  coef,
  var.coef,
  thin = 1,
  burn.in = 1000,
  tau.u = 1,
  data
)
}
\arguments{
\item{formula}{Formula that describe the fitted model}

\item{iter.update}{Number of updates with default \code{3}}

\item{iter.mcmc}{Number of total iterations per chain with default \code{2000}}

\item{coef}{Regression coefficient for variable of interest \eqn{(y)}}

\item{var.coef}{Variance of coefficient}

\item{thin}{Thinning rate, must be a positive integer with default \code{1}}

\item{burn.in}{Number of iterations to discard at the beginning with default \code{1000}}

\item{tau.u}{Variance of random effect area for non-zero count of variable interest with default \code{1}}

\item{data}{The data frame}
}
\value{
This function returns a list of the following objects:
   \item{Est}{A vector with the values of Small Area mean Estimates using Hierarchical Bayesian method}
   \item{refVar}{Estimated random effect variances}
   \item{coefficient}{A dataframe contains the estimated model coefficient}
   \item{alpha}{Parameter dispersion of Generalized Poisson distribution}
   \item{plot}{Trace, Density, Autocorrelation Function Plot of MCMC samples}
}
\description{
This function is implemented to variable of interest \eqn{(y)} that assumed to be a Generalized Poisson Distribution. The range of data is \eqn{0 < y < \infty}. Generalized Distribution model can be used to handle underdispersion and overdispersion in count data.
}
\examples{
##For data without any non-sampled area
data(dataGPois)     # Load dataset

result <- GPois(y ~ x1 + x2, data = dataGPois)

result$Est           # Small Area mean estimates
result$refVar        # Estimated random effect variances
result$coefficient   # Estimated model coefficient
result$alpha         # Paramter of dispersion

# Load library 'coda' to execute the plot
# autocorr.plot(result$plot[[3]])  # Generate ACF Plot
# plot(result$plot[[3]])           # Generate Density and Trace Plot

## For data with non-sampled area use dataGPoisNs

}
