% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FHme_nonsamples.R
\name{FHme_nonsamples}
\alias{FHme_nonsamples}
\title{Fay-Herriot Model with Measurement Error of Nonsampled Area}
\usage{
FHme_nonsamples(
  formula,
  var.x,
  vardir,
  type.x = "witherror",
  MAXITER = 100,
  PRECISION = 1e-04,
  cluster.method = "kmeans",
  n.cluster,
  data
)
}
\arguments{
\item{formula}{an object of class \code{\link[stats]{formula}} (or one that can be coerced to that class): a symbolic description of the model to be fitted. The variables included  \code{formula} must have a length equal to the number of domains \code{m}. This formula can provide auxiliary variable either measured with error or without error or combination between them. If the auxiliary variable are combination between \code{noerror} and \code{witherror} variable, input all \code{witherror} variable first then \code{noerror} variable.}

\item{var.x}{vector containing mean squared error of \code{X} . The values must be sorted as the \code{X}. Input this parameter use \code{c("")}, example: \code{var.x = c("c1") or var.x = c("c1","c2")}.}

\item{vardir}{vector containing the \code{m} sampling variances of direct estimators for each domain. The values must be sorted as the \code{Y}.}

\item{type.x}{type of auxiliary variable used in the model. Either source measured with \code{noerror}, \code{witherror} and \code{mix}. Default value is \code{witherror}.}

\item{MAXITER}{maximum number of iterations allowed. Default value is \code{1000} iterations.}

\item{PRECISION}{convergence tolerance limit. Default value is \code{0.0001}.}

\item{cluster.method}{the cluster method used. Default value is \code{kmeans} and the other available method is \code{kmedoids}.}

\item{n.cluster}{either the number of clusters, say \code{k}, or a set of initial (distinct) cluster centers.}

\item{data}{a data frame containing the variables named in formula, vardir, and var.x.}
}
\value{
The function returns a list with the following objects:
\describe{
   \item{\code{nonsampled_data}}{a data frame of nonsampled areas containing \code{data}, the cluster information (\code{cluster}) and mean of random effect for each cluster (\code{refmean}).}
   \item{\code{sampled_data}}{a data frame of sampled areas containing \code{data}, the cluster information (\code{cluster}) and mean of random effect for each cluster (\code{refmean}).}
   \item{\code{result_sampled}}{a list containing following objects:}
   \itemize{
    \item \code{eblup}: vector with the values of the estimators for the sampled areas.
    \item \code{fit}: a list of \code{method}, \code{convergence}, \code{iterations}, \code{estcoef}, \code{refvar}, and \code{gamma}. For the description of these objects, see Value of \link{FHme} function.
    \item \code{ref}: values of the random effect for each area.
   }
   \item{\code{result_nonsampled}}{a list containing following objects:}
   \itemize{
    \item \code{eblup}: vector with the values of the estimators for the nonsampled areas.
    \item \code{estcoef}: a data frame with the estimated model coefficient (\code{beta}) in the first column, their standard error (\code{std.error}) in the second column, the t-statistics (\code{t.statistics}) in the third column, and the p-values of the significance of each coefficient (\code{pvalue}) in the last column.
   }
   \item{\code{mse_sample}}{a list containing the values of \code{mse} a vector with the estimated mean squared errors of the EBLUPs for the sampled areas.}
   \item{\code{mse_nonsample}}{a list containing the values of \code{mse} a vector with the estimated mean squared errors of the EBLUPs for the nonsampled areas.}
   \item{\code{cluster}}{a data frame with the cluster information (\code{cluster}) in the first column and mean of random effects for each cluster (\code{refmean}) in the second column.}
 }
}
\description{
This function gives the EBLUP estimator of nonsampled area using cluster information.
}
\details{
A formula has an implied intercept term. To remove this use either y ~ x - 1 or y ~ 0 + x. See \code{\link[stats]{formula}}  for more details of allowed formulae.
}
\examples{
\donttest{
data(nonsample)
test <- FHme_nonsamples(formula = y ~ x.hat, var.x = c("var.x"),
                        vardir = vardir, n.cluster = 3, data = nonsample)
}

}
