% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxa.R
\name{add_taxa}
\alias{add_taxa}
\title{Add a taxonomic hierarchy to a SAFE data worksheet.}
\usage{
add_taxa(
  obj,
  taxon_field = NULL,
  taxon_table = NULL,
  prefix = NULL,
  which = NULL
)
}
\arguments{
\item{obj}{An existing object of class \code{safedata}}

\item{taxon_field}{The name of a taxon field in a \code{safedata} for which
to add taxonomic data.}

\item{taxon_table}{An existing taxon table for a dataset, as generated by 
\code{\link{get_taxa}}.}

\item{prefix}{A string to be appended to taxon field names, primarily to
discriminate between fields of multiple taxonomies are to be added.}

\item{which}{A vector specifying a subset of taxonomy table field names to add.}
}
\value{
A modified \code{safedata} object with added taxonomic columns.
}
\description{
All datasets containing taxon observations provide taxonomic data (see
\code{\link{get_taxa}}) that can be linked to rows in data worksheets 
that contain 'taxa' fields. This function matches the taxonomic hierarchy 
for a dataset for a given taxon field in a data worksheet and inserts fields
to show that hierarchy.
}
\details{
An existing taxon table can be provided to the function, but the table
will be automatically loaded if no table is provided. If a data worksheet 
only contains a single taxon field, then that field will be used
automatically, otherwise users have to specify which taxon field to use.
A prefix can be added to taxon fields in order to discrimate between fields
from multuple taxon fields. By default, the function adds all of the fields
included in the output of \code{\link{get_taxa}}, but \code{which} 
allows a subset of field names to be used.
}
\examples{
   set_example_safe_dir()
   beetle_morph <- load_safe_data(1400562, 'MorphFunctTraits')
   beetle_morph <- add_taxa(beetle_morph)
   unset_example_safe_dir()
}
\seealso{
\code{\link{get_taxa}}
}
