% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluateStandard.R
\name{evaluateStandard}
\alias{evaluateStandard}
\title{Evaluate a data set against a data standard}
\usage{
evaluateStandard(data, meta, domain, standard)
}
\arguments{
\item{data}{A data frame in which to detect the data standard}

\item{meta}{the metadata containing the data standards.}

\item{domain}{the domain to evaluate - should match a value of \code{meta$domain}}

\item{standard}{standard to evaluate}
}
\value{
a list describing to what degree the data set matches the data standard. The "match" property describes compliance with the standard as "full", "partial" or "none". The "checks" property is a list of the data elements expected for the standard and whether they are "valid" in the given data set. "total_checks", "valid_checks" and "invalid_checks" provide counts of the specified checks. "match_percent" is calculated as valid_checks/total_checks.  "mapping" is a data frame describing the detected standard for each \code{"text_key"} in the provided metadata. Columns are \code{"text_key"}, \code{"current"} containing the name of the matched column or field value in the data and \code{"match"} a boolean indicating whether the data matches the standard.
}
\description{
Determines whether the required data elements in a data standard are found in a given data frame
}
\examples{
# Match is TRUE
evaluateStandard(
 data=safetyData::adam_adlbc, 
 meta=meta, 
 domain="labs", 
 standard="adam"
) 

# Match is FALSE
evaluateStandard(
 data=safetyData::adam_adlbc, 
 meta=meta, 
 domain="labs", 
 standard="sdtm"
) 

}
