\name{downLogs-methods}
\docType{methods}
\alias{downLogs-methods}
\alias{downLogs,data.frame,missing-method}
\alias{downLogs,list,missing-method}
\alias{downLogs,numeric,bufferedTract-method}
\alias{downLogs,numeric,matrix-method}
\alias{downLogs,numeric,missing-method}

\title{ Methods for "downLogs" Object Construction }

\description{
 The following are the constructor methods for class
 \dQuote{\code{\linkS4class{downLogs}}} 
 in Package `sampSurf'. Please see \dQuote{\emph{The Stem Class}}
 vignette for more information and examples on the usage of the methods.
}

\section{Methods}{
\describe{

\item{\strong{\code{signature(object = "list", container = "missing")}}}{%\cr

    Ultimately, all of the constructors end up calling this one to
	generate the object after they have done what they were meant to,
	and then converted all of the \dQuote{\code{\linkS4class{downLog}}}
	objects into a \code{\link{list}} structure. So if one wishes, one
	can simply create one's own list of \dQuote{downLog} objects and use
	this constructor. }
  
  \item{}{\bold{usage\ldots}
    \preformatted{function(object, ... )}
	\itemize{
	  \item{\code{object}:}{ A \code{list} as discussed above.}
	  
	  \item{... :}{ Other arguments to be passed along (not used currently).}
	} %itemize
  } %item
  
  
\item{\strong{\code{signature(object = "data.frame", container =
	  "missing")}}}{%\cr

    This particular method allows one to pass a data frame in the form
	generated from \code{\link{sampleLogs}} in \code{object} to
	construct an object. Note, however, that the data frame does not
	have to be created by \code{sampleLogs}, and it does not have to
	contain synthetic/simulated logs. As long as all of the columns are
	present that are generated by \code{sampleLogs} it will be used; for
	example, the data frame can be constructed from a field sample of
	logs.  }
  
  \item{}{\bold{usage\ldots}
    \preformatted{function(object, units = 'metric', ... )}
	\itemize{
	  \item{\code{object}:}{ A data frame as discussed above.}
	  
	  \item{\code{units}:}{ The units of measurement.}
	  
	  \item{... :}{ Other arguments to be passed along to the
        \code{\link{downLog}} constructor---these apply uniformly to all
        logs in the collection.}
	} %itemize
  } %item
		

\item{\strong{\code{signature(object = "numeric", container =
	  "bufferedTract")}}}{%\cr 

  This method will take as it's first argument (\code{object}) the
  number of logs to be synthetically generated. The centers of the logs
  will all lie within the interior region of the
  \dQuote{\code{\linkS4class{bufferedTract}}} object passed in the
  second (\code{container}) argument. }
  
  \item{}{\bold{usage\ldots}
    \preformatted{function(object, container, units = 'metric', ... )}
	\itemize{
	  \item{\code{object}:}{ A numeric (truncated to integer) object specifying the number
        of logs to generate as discussed above.}
	  
	  \item{\code{container}:}{ A \dQuote{\code{\linkS4class{bufferedTract}}}
        object specifying the internal portion of the tract withing
        which the log centers will be generated.}
	  
	  \item{\code{units}:}{ The units of measurement.}
	  
	  \item{... :}{ Other arguments to be passed along to the last
        constructor described below.}
	} %itemize
  } %item



\item{\strong{\code{signature(object = "numeric", container = "missing")}}}{%\cr

  This constructor looks like it just generates logs randomly. But in
  reality, note the arguments below. It takes limits of a rectangular
  region as an alternative to specifying a bounding box matrix or a
  \dQuote{bufferedTract} object as in two of the other
  constructors. Essentially, these limits get converted to a matrix
  bounding box and the appropriate constructor is used (see below).
}
  
  \item{}{\bold{usage\ldots}
    \preformatted{function(object,
         xlim = c(0,100), 
         ylim = c(0,50),
         units = 'metric',
         ...)}
	\itemize{
	  \item{\code{object}:}{ See explanation in the following constructor
		method.}
	  
	  \item{\code{units}:}{ The units of measurement.}
	  
	  \item{\code{xlim}:}{ Limits for the bounding rectangle in
		\code{x}.}
	  
	  \item{\code{ylim}:}{ Limits for the bounding rectangle in
		\code{y}.}
	  
	  \item{... :}{ Other arguments to be passed along as described in
        the last constructor method.}	  
	} %itemize
 } %item



  
\item{\strong{\code{signature(object = "numeric", container = "matrix")}}}{%\cr

  Like the previous constructor, the logs will be generated so that
  their centers lie within a rectangular area specified by the
  \code{matrix} object in the second argument. Note that ultimately, the
  synthetic population of logs is generated by a call to
  \code{\link{sampleLogs}}. }
  
  \item{}{\bold{usage\ldots}
    \preformatted{function(object,
         container,
         units = 'metric',
         buttDiams = c(8, 40), 
         topDiams = c(0, 0.9), 
         logLens = c(1,10),
         logAngles = c(0, 2*pi),
         solidTypes = c(1,10),
         species = .StemEnv$species,
         ... )}
	\itemize{
	  \item{\code{object}:}{ A numeric (truncated to integer) object specifying the number
        of logs to generate as discussed above.}
	  
	  \item{\code{container}:}{ A \code{matrix} object specifically in the form
        of a \code{\link{bbox}}, bounding box object (e.g., see the
        \code{\link{sp}} package). It must be a \code{2x2} matrix with row names
        \code{c("x","y")} and the column names must be
        \code{c("min","max")}. The object specifies the internal portion
        of the tract within which the log centers will be generated.}
	  
	  \item{\code{units}:}{ The units of measurement.}
	  
	  \item{\code{buttDiams}:}{ A length-two vector specifying the
        \emph{range} of butt (large-end) diameters from which to
        uniformly draw the sample. Note that this range is assumed to be
        specified in cm for metric and inches for English units.}
	  
	  \item{\code{topDiams}:}{ A length-two vector specifying the
        \emph{range} of top (small-end) diameters in the form of a
        \emph{proportion} of the \code{buttDiam} diameters, from which
        to uniformly draw the sample. See also
        \code{\link{sampleLogs}}.}
	  
	  \item{\code{logLens}:}{ A length-two vector specifying the
        \emph{range} of log lengths in feet (English) or meters (metric)
        from which to uniformly draw the sample.}
	  
      \item{\code{logAngles}:}{ A length-two vector specifying the \emph{range}
        of log angles from which to draw the log lie angles; these are
        always counterclockwise relative to due East.}
	  
	  \item{\code{solidTypes}:}{ A length-two vector specifying the range in
        the log shape parameter for the default taper 
        and volume equations; where: 1-2 is a neiloid, 2-3 is a cone,
        and >3 is a paraboloid.}
	  
	  \item{\code{species}:}{ A character vector of possible species from which
        to draw the sample uniformly. This can be any legal character
        string, and so can include codes, names, Latin names, etc.}
	  
	  \item{... :}{ Other arguments to be passed along to
        \code{\link{sampleLogs}}. Note specifically that one can control
        the random number stream by specifying a seed to be passed to
        \code{sampleLogs} with its \code{startSeed} argument. Additionally,
        this list can also contain arguments to be ultimately passed on to
        the \code{\link{downLog}} constructor to be applied to each
        individual log in the collection. For example, one can specify the
        number of segments desired in the taper function (\code{nSegs}) in
        this way.}
	  
	} %itemize
  } %item



}}
\keyword{methods}
\keyword{ ~~ other possible keyword(s) ~~ }
