% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/b4ddp.R
\name{b4ddp}
\alias{b4ddp}
\title{Statistical power for a hyphotesis testing on a difference of proportions}
\usage{
b4ddp(N, n, P1, P2, P3, P4, D, DEFF = 1, conf = 0.95, plot = FALSE)
}
\arguments{
\item{N}{The population size.}

\item{n}{The sample size.}

\item{P1}{The value of the first estimated proportion.}

\item{P2}{The value of the second estimated proportion.}

\item{P3}{The value of the third estimated proportion.}

\item{P4}{The value of the fourth estimated proportion.}

\item{D}{The value of the null effect.}

\item{DEFF}{The design effect of the sample design. By default \code{DEFF = 1}, which corresponds to a simple random sampling design.}

\item{conf}{The statistical confidence. By default \code{conf = 0.95}.}

\item{plot}{Optionally plot the power achieved for an specific sample size.}
}
\value{
The power of the test.
}
\description{
This function computes the power for a (right tail) test of difference of proportions.
}
\details{
We note that the power is defined as: \deqn{1-\Phi(Z_{1-\alpha} - \frac{(D - [(P_1 - P_2) - (P_3 - P_4)])}{\sqrt{\frac{DEFF}{n}(1-\frac{n}{N})(P_1Q_1+P_2Q_2+P_3Q_3+P_4Q_4)}})}
}
\examples{
b4ddp(N = 10000, n = 400, P1 = 0.5, P2 = 0.5, P3 = 0.5, P4 = 0.5, D = 0.03)
b4ddp(N = 10000, n = 400, P1 = 0.5, P2 = 0.5, P3 = 0.5, P4 = 0.5, D = 0.03, plot = TRUE)
b4ddp(N = 10000, n = 4000, P1 = 0.5, P2 = 0.5, P3 = 0.5, P4 = 0.5, 
D = 0.05, DEFF = 2, conf = 0.99, plot = TRUE)
}
\author{
Hugo Andres Gutierrez Rojas <hugogutierrez at usantotomas.edu.co>
}
\references{
Gutierrez, H. A. (2009), \emph{Estrategias de muestreo: Diseno de encuestas y estimacion de parametros}. Editorial Universidad Santo Tomas
}
\seealso{
\code{\link{ss4p}}
}

