% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/srsdomainestimator.R
\name{srsdomainestimator}
\alias{srsdomainestimator}
\title{Simple Random Sample parameter estimation of domains.}
\usage{
srsdomainestimator(
  Nj,
  data,
  estimator = c("total", "mean", "proportion", "class total"),
  domain,
  replace = FALSE
)
}
\arguments{
\item{Nj}{Number of instances of the data set domain.}

\item{data}{Sample of the data. It must constain a column with the data to estimate
and a second column with the domain of each instance.}

\item{estimator}{One of "total", "mean". Default is "total".}

\item{domain}{Domain of the sample from which parameter estimation will be done.}

\item{replace}{Whether the sample to be taken can have repeated instances or not.}
}
\value{
A list containing different interest values:
\itemize{
\item estimator
\item variance
\item sampling.error
\item estimation.error
\item confint
}
}
\description{
Function to make estimations of diferent parameters on a given domain
based on a Simple Random Sample.
}
\details{
Data columns must be arranged with interest values on the first column
and domain values on the last column.\cr
Domain parameter can be either numeric or character
and must be equal to one of the values of the domain column of data.
}
\examples{
data<-cbind(rnorm(500, 50, 20), rep(c(1:2),250))
sample<-data[srs(500, 100),]
sum(data[which(data[,-1]==1),1])
srsdomainestimator(Nj = 250, data = sample, estimator="total", domain=1)

}
\references{
César Pérez (1999) Técnicas de muestreo estadístico. Teoría, práctica y aplicaciones informáticas. 193-195
}
