% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_functions.R
\name{calc_qqplot}
\alias{calc_qqplot}
\title{QQ-Plot Calculator}
\usage{
calc_qqplot(chain, change = TRUE, plot = FALSE)
}
\arguments{
\item{chain}{Vector of n length, where n is the number of trials or sampler iterations}

\item{change}{Boolean. If false, it calculates a qqplot of the given chain. If true, it creates a chain of step sizes.}

\item{plot}{Boolean. Whether to plot the QQ plot or just return the values.}
}
\value{
A list with the theoretical and empirical quantiles, and the intercept and slope of the line connecting the points
}
\description{
Estimates values for a QQ plot of Empirical values against Theoretical values from a normal distribution, for either the chain points or the distances between successive points. Optionally, returns a plot as well as the values.
}
\examples{
set.seed(1)
chain1 <- sampler_mh(1, "norm", c(0,1), diag(1))
calc_qqplot(chain1[[1]], plot = TRUE)
}
