% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/santaR_auto_fit.R
\name{santaR_auto_fit}
\alias{santaR_auto_fit}
\title{Automate all steps of santaR fitting, Confidence bands estimation and p-values calculation for one or multiple variables}
\usage{
santaR_auto_fit(
  inputData,
  ind,
  time,
  group = NA,
  df,
  ncores = 0,
  CBand = TRUE,
  pval.dist = TRUE,
  pval.fit = FALSE,
  nBoot = 1000,
  alpha = 0.05,
  nPerm = 1000,
  nStep = 5000,
  alphaPval = 0.05,
  forceParIndTimeMat = FALSE
)
}
\arguments{
\item{inputData}{\code{data.frame} of measurements with observations as rows and variables as columns.}

\item{ind}{Vector of subject identifier (individual) corresponding to each measurement.}

\item{time}{Vector of the time corresponding to each measurement.}

\item{group}{NA or vector of group membership for each measurement. Default is NA for no groups.}

\item{df}{(float) Degree of freedom to employ for fitting the individual and group mean \code{\link[stats]{smooth.spline}}.}

\item{ncores}{(int) Number of cores to use for parallelisation. Default 0 for no parallelisation.}

\item{CBand}{If TRUE calculate confidence bands for group mean curves. Default is TRUE.}

\item{pval.dist}{If TRUE calculate \emph{p}-value based on inter-group mean curve distance. Default is TRUE.}

\item{pval.fit}{If TRUE calculate \emph{p}-value based on group mean curve improvement in fit. Default is FALSE.}

\item{nBoot}{(int) Number of bootstrapping rounds for confidence band calculation. Default 1000.}

\item{alpha}{(float) Confidence \emph{(0.05 for 95\% Confidence Bands)}. Default 0.05.}

\item{nPerm}{(int) Number of permutations for \emph{p}-value calculation. Default 1000.}

\item{nStep}{(int) Number of steps (granularity) employed for the calculation of the area between group mean curves (\emph{p-value dist}). Default is 5000.}

\item{alphaPval}{(float) Confidence Interval on the permuted \emph{p}-value \emph{(0.05 for 95\% Confidence Interval)}. Default 0.05.}

\item{forceParIndTimeMat}{If TRUE parallelise the preparation of input data by \code{\link{get_ind_time_matrix}}. Default is FALSE.}
}
\value{
A list of \emph{SANTAObj} corresponding to each variable's analysis result.
}
\description{
\code{santaR_auto_fit} encompasses all the analytical steps for the detection of significantly altered time trajectories (\emph{input data preparation: \code{\link{get_ind_time_matrix}}, establishing group membership: \code{\link{get_grouping}}, spline modelling of individual and group time evolutions: \code{\link{santaR_fit}}, computation of group mean curve confidence bands: \code{\link{santaR_CBand}}, identification of significantly altered time trajectories: \code{\link{santaR_pvalue_dist}} and/or \code{\link{santaR_pvalue_fit}}}). As \emph{santaR} is an univariate approach, multiple variables can be processed independently, which \code{santaR_auto_fit} can execute in parallel over multiple CPU cores.
}
\details{
\subsection{Note}{
  \itemize{
    \item The calculation of confidence bands accounts for approximately a third of the time taken by \code{santaR_auto_fit}, while the identification of significantly altered time trajectories (either \code{\link{santaR_pvalue_dist}} or \code{\link{santaR_pvalue_fit}}) accounts for two third of the total time. The time taken by these steps increases linearly with the increase of their respective parameters: \code{nBoot} for confidence bands, \code{nPerm} and \code{nStep} for identification of significantly altered trajectories using \code{\link{santaR_pvalue_dist}}, \code{nPerm} for \code{\link{santaR_pvalue_fit}}. Default values of these parameters are optimised to balance the time taken with the precision of the value estimation; increasing \code{nPerm} can tighten the \emph{p}-value confidence intervals.
    \item If the parallelisation is activated (\emph{\code{ncores>0}}), the fit of spline models, the calculation of confidence bands on the group mean curves and the identification of altered trajectories are executed for multiple variables simultaneously. However the preparation of input data (\code{\link{get_ind_time_matrix}}) is not parallelised by default as the parallelisation overhead cost is superior to the time potentially gained for all but the most complex datasets. The parallelisation overhead (\emph{instantiating worker nodes, duplicating and transferring inputs to the worker nodes, concatenating results}) typically equals around 2 seconds, while executing \code{\link{get_ind_time_matrix}} is usually a matter of millisecond for a single variable (\emph{ex: 7 time-points, 24 individuals, 1 variable)}; the parallelisation overhead far exceeding the time needed to process all variables sequentially. If the number of individual trajectories (subjects), of time-points, or of variables is very large, \code{forceParIndTimeMat} enables the parallelisation of \code{\link{get_ind_time_matrix}}.
  }
}
}
\examples{
## 2 variables, 56 measurements, 8 subjects, 7 unique time-points
## Default parameter values decreased to ensure an execution < 2 seconds
inputData     <- acuteInflammation$data[,1:2]
ind           <- acuteInflammation$meta$ind
time          <- acuteInflammation$meta$time
group         <- acuteInflammation$meta$group
SANTAObjList  <- santaR_auto_fit(inputData, ind, time, group, df=5, ncores=0, CBand=TRUE,
                                pval.dist=TRUE, nBoot=100, nPerm=100)
# Input data generated: 0.02 secs
# Spline fitted: 0.03 secs
# ConfBands done: 0.53 secs
# p-val dist done: 0.79 secs
# total time: 1.37 secs
length(SANTAObjList)
# [1] 2
names(SANTAObjList)
# [1] "var_1" "var_2"

}
\seealso{
Other AutoProcess: 
\code{\link{santaR_auto_summary}()},
\code{\link{santaR_plot}()},
\code{\link{santaR_start_GUI}()}

Other Analysis: 
\code{\link{get_grouping}()},
\code{\link{get_ind_time_matrix}()},
\code{\link{santaR_CBand}()},
\code{\link{santaR_auto_summary}()},
\code{\link{santaR_fit}()},
\code{\link{santaR_plot}()},
\code{\link{santaR_pvalue_dist}()},
\code{\link{santaR_pvalue_fit}()},
\code{\link{santaR_start_GUI}()}
}
\concept{Analysis}
\concept{AutoProcess}
