% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tweet_topics.R
\name{tweet_topics}
\alias{tweet_topics}
\title{Tweet Topics}
\usage{
tweet_topics(DataFrame, clusters, method = "Gibbs", set_seed = 1234,
  num_terms = 10)
}
\arguments{
\item{DataFrame}{DataFrame of Twitter Data.}

\item{clusters}{The number of latent clusters.}

\item{method}{method = "Gibbs"}

\item{set_seed}{Seed for reproducable results.}

\item{num_terms}{The desired number of terms to be returned for each topic.}
}
\value{
Returns LDA topics.
}
\description{
Determines the Latent topics within a dataframe by using Latent Dirichlet Allocation (LDA) model parameters.  
Uses the `ldatuning` package and outputs an ldatuning plot.  
Prepares Tweet text, creates DTM, conducts LDA, display data terms associated with each topic.
}
\examples{
\donttest{
library(saotd)
data <- raw_tweets
LDA_data <- tweet_topics(DataFrame = data,
                         clusters = 8,
                         method = "Gibbs",
                         set_seed = 1234,
                         num_terms = 10)

LDA_data
}
}
