% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge_terms.R
\name{merge_terms}
\alias{merge_terms}
\title{Merge Terms}
\usage{
merge_terms(DataFrame, term, term_replacement, ignore_case = TRUE)
}
\arguments{
\item{DataFrame}{Data Frame of Twitter Data.}

\item{term}{Term selected for merging.}

\item{term_replacement}{Desired replacement term.}

\item{ignore_case}{True is the default setting and will ignore case 
sensitivity of the selected terms.  Selecting FALSE will maintain 
case sensitivity.}
}
\value{
A Tibble with user selected term replacement.
}
\description{
Function to merge terms within a data frame and prevent 
  redundancy in the analysis.  For example many users may refer to the same
  entity in multiple different ways: President Trump, The U.S. President, 
  POTUS, Trump, President Donald Trump, Donald Trump, etc.  While each entry 
  is different, they all refer to the same individual.  Using Merge Terms 
  will allow all be converted into a single term.
}
\examples{
\dontrun{
library(saotd)
data <- raw_tweets
data <- merge_terms(DataFrame = data,
                    term = "ice cream",
                    term_replacement = "ice_cream")
data
}
}
