% Generated by roxygen2 (4.0.2): do not edit by hand
\name{rankConcordance}
\alias{rankConcordance}
\title{Compute concordance indices}
\usage{
rankConcordance(dataset, survivalTimes, followup)
}
\arguments{
\item{dataset}{A matrix, where the column names are gene identifiers
and the values are gene expression levels. Each row should contain data for
a single patient.}

\item{survivalTimes}{A vector of survival times. The length must equal the number of
rows (i.e. patients) in \code{dataset}.}

\item{followup}{A vector of 0 or 1 values, indicating whether the patient was
lost to followup (0) or not (1). The length must equal the number of rows
(i.e. patients) in \code{dataSet}.}
}
\value{
The function returns a matrix with two columns:

\item{cindex}{concordance index estimate.}
\item{z}{z-score of the concordance index estimate.}

and as many rows as \code{dataset}. The row names contain the gene identifiers.
}
\description{
Computes concordance indices for a gene expression data set,
and returns the concordance index and the z-score.
}
\details{
This function is a wrapper for
\code{\link[survcomp]{concordance.index}} in the \pkg{survcomp}
package. It applies the latter over the columns of \code{dataset} to
calculate concordance indices and the corresponding z-score for each gene.
}
\examples{
# 25 patients, none lost to followup
followup <- rep(1, 25)

# first 5 patients have good survival (in days)
time <- c(25, 27, 24, 21, 26, sample(1:3, 20, TRUE))*365

# create data for 100 genes, 25 patients
dat <- matrix(rnorm(25*100), nrow=25, ncol=100)
colnames(dat) <- as.character(1:100)

ci <- rankConcordance(dat, time, followup)
z <- ci[,"z"]
range(z)
hist(z)
}
\seealso{
\code{\link{saps}} \code{\link[survcomp]{concordance.index}}
}

