% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_qmd_chapters.R
\name{gen_qmd_chapters}
\alias{gen_qmd_chapters}
\title{Generate A Quarto Survey Report}
\usage{
gen_qmd_chapters(
  chapter_structure,
  data,
  authors_col = "author",
  path = NULL,
  ignore_heading_for_group = NULL,
  replace_heading_for_group = NULL,
  prefix_heading_for_group = NULL,
  suffix_heading_for_group = NULL,
  chapter_yaml_file = NULL,
  chapter_qmd_start_section_filepath = NULL,
  chapter_qmd_end_section_filepath = NULL,
  attach_chapter_dataset = TRUE,
  auxiliary_variables = NULL,
  serialized_format = "rds",
  filename_prefix = "",
  data_filename_prefix = "data_"
)
}
\arguments{
\item{chapter_structure}{\emph{What goes into each chapter and sub-chapter}

\verb{obj:<data.frame>|obj:<tbl_df>} // Required

Data frame (or tibble, possibly grouped). One row per chapter. Should
contain the columns 'chapter' and 'dep', Optionally 'indep' (independent
variables) and other informative columns as needed.}

\item{data}{\emph{Survey data}

\verb{obj:<data.frame>|obj:<tbl_df>|obj:<srvyr>} // Required

A data frame (or a srvyr-object) with the columns specified in the
chapter_structure 'dep', etc columns.}

\item{authors_col}{\emph{Column name for author}

\verb{scalar<character>} // \emph{default:} \code{"author"} (\code{optional})

Only used if it exists. Multiple authors are separated by semicolon (and optionally with a subsequent space).}

\item{path}{\emph{Output path}

\verb{scalar<character>} // \emph{default:} \code{tempdir()} (\code{optional})

Path to save all output. Defaults to a temporary directory.}

\item{ignore_heading_for_group}{\emph{Ignore heading for group}

\verb{vector<character>} // \emph{default:} \code{NULL} (\code{optional})

Type of refined chapter_structure data for which to suppress the heading
in the report output. Typically variable_name_dep, variable_name_indep, etc.}

\item{replace_heading_for_group}{\emph{Replacing heading for group}

\verb{named vector<character>} // \emph{default:} \code{c(".variable_label_suffix_dep" = ".variable_name_dep")}

Occasionally, one needs to replace the heading with another piece of information
in the refined chapter_structure. For instance, one may want to organize output
by variable_name_indep, but to display the variable_label_indep instead. Use
the name for the replacement and the value for the original.}

\item{prefix_heading_for_group, suffix_heading_for_group}{\emph{Prefix and suffix headings}

\verb{vector<named character>} // \emph{default:} \code{NULL} (\code{optional})

Names are heading_groups, values are the prefixes and suffixes. Note
that prefixes should end with a \verb{\\n} as headings must begin on a new line.}

\item{chapter_yaml_file}{\emph{Path to YAML-file to insert into each chapter qmd-file}

\verb{scalar<character>} // \emph{default:} \code{NULL} (\code{optional})

Path to file used to insert header YAML, in each chapter.}

\item{attach_chapter_dataset}{\emph{Toggle inclusion of chapter-specific datasets in qmd-files}

\verb{scalar<logical>} // \emph{default:} \code{FALSE}

Whether to save in each chapter folder an 'Rds'-file with the
chapter-specific dataset, and load it at the top of each QMD-file.}

\item{auxiliary_variables}{\emph{Auxiliary variables to be included in datasets}

\verb{vector<character>} // \emph{default:} \code{NULL} (\code{optional})

Column names in \code{data} that should always be included in datasets for
chapter qmd-files, if \code{attach_chapter_dataset=TRUE}. Not publicly available.}

\item{serialized_format}{\emph{Serialized format}

\verb{scalar<string>} // \emph{default:} \code{"rds"}

Format for serialized data when storing chapter dataset.
One of \code{"rds"} (default), \code{"qs"} or \code{"fst"}.
The latter two requires the respective packages to be installed.
\code{"qs"} is usually the fastest and most space efficient, but sets package
dependencies on the report project.}

\item{filename_prefix}{\emph{Prefix string for all qmd filenames}

\verb{scalar<character>} // \emph{default:} \code{""} (\code{optional})

For mesos setup it might be useful to set these files (and related sub-folders) with an underscore
(\code{filename_prefix = "_"}) in front as other stub files will include these main qmd files.}

\item{data_filename_prefix}{\emph{String attached to beginning of data-file and data-object}

\verb{scalar<string>} // \emph{default:} \code{"data_"}}
}
\value{
Side-effects: qmd-files generated in the specified working directory.
}
\description{
This function generates a set of saros chapters, collectively called a report.
}
\details{
A report consists of multiple chapters, an index file, and optionally a combined report file that merges them together.
A chapter can contain any user-defined set of dependent, independent or bivariate variable sets.
A chapter consists of multiple sections.
A section is defined as a group in the chapter_structure (ignoring the chapter
grouping level) containing variables of the same type, meaning at a minimum
that the variables in the section sharing the same response options, the same
main question, and being of the same data type.
}
\keyword{internal}
