% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/render_full_reports.R
\name{render_full_reports}
\alias{render_full_reports}
\title{Post-render rendering of complete reports}
\usage{
render_full_reports(
  files = NULL,
  path,
  processable_path = file.path(path, "Reports"),
  site_path = file.path(path, "_site"),
  resource_paths = file.path(path, c("_extensions", "_images")),
  warn_on_file_error = FALSE,
  ...
)
}
\arguments{
\item{files}{Optional character vector of report files (qmd). Can be obtained within a project by \code{Sys.getenv("QUARTO_PROJECT_OUTPUT_FILES")}}

\item{path}{If no files are given, a path to the root folder of the local "site".}

\item{processable_path}{Path to where report files can be (recursively) found.}

\item{site_path}{Path to _site}

\item{resource_paths}{Paths to where _extensions and _images folders can be found and copied to wherever needed}

\item{warn_on_file_error}{If TRUE, will collect warnings if a file fails to render or be copied. If FALSE (default), will stop the rendering process.}

\item{...}{Additional arguments passed to \code{quarto::render()}}
}
\value{
Returns invisibly a character vector of processed files.
}
\description{
If one wishes to render complete reports that are linked to
in a website, but not listed among the chapters on the sidebar menu,
one can make these with filenames starting with underscores (_) which
will make them not listed in said menu. However, this will also mean they
are not rendered in a Quarto (Website) project. This function, which can
be called within a post-script (see example below), will render only these
after the ordinary rendering of the project, and copied to the _site folder.
}
\keyword{internal}
