% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backtrackLayers.R
\name{backtrackLayers}
\alias{backtrackLayers}
\title{Backtrack layers from average or summary profile}
\usage{
backtrackLayers(
  avgProfile,
  layer = NA,
  profileSet = NULL,
  layer_units = "row#",
  condition = NULL,
  computationByHeight = FALSE
)
}
\arguments{
\item{avgProfile}{an average profile as per \link{dbaSP}}

\item{layer}{the height or row number of the layer to retrieve the distribution for (given as height or row number of the average profile). If layer
is \code{NA}, all layers from the avgProfile are considered.}

\item{profileSet}{the profile set that is averaged by \code{avgProfile}. Optimally, it is the resampled profile set as returned by \link{dbaSP} or \link{averageSP}, see parameter \code{computationByHeight}
if that resampled profile set is not available anymore.}

\item{layer_units}{either \code{"row#"} or \code{"cm"}}

\item{condition}{a condition that subsets which layers are returned. E.g., only layers with a specific grain type, etc.. Note that the condition needs to be substituted in the
function call, e.g. \code{condition = substitute(gtype == "SH")}. In most cases, it's best to subset the data.frame manually after this function has been called. A \emph{secret} and \emph{dangerous} trick is
to use \code{condition = substitute(gtype \%in\% return_conceptually_similar_gtypes(as.character(avgProfile$layers$gtype[lidx])))} to get the very same layers that have been used to compute the median
layer properties which are included in the avgProfile$layers.}

\item{computationByHeight}{There are two ways of how to backtrack layers that were aligned to \code{avgProfile$layers}. The first and safest approach is by index, which requires the
resampled \code{profileSet} as returned by \link{dbaSP} or \link{averageSP}. The second approach is by layer height, which should yield the same results (beta phase: still bugs possible, check yourself!)
and allows to backtrack the layers even if the resampled profileSet is not available anymore, but only the original unmodified set which was used to create the average profile.}
}
\value{
This function returns a list of data.frames with the backtracked layers. Each (named) list item corresponds to a specific layer height (cm).
}
\description{
An average profile as computed by \link{dbaSP} summarizes the prevalent layer properties of the entire profile set. To better
understand the distribution of layer properties within the set, use this function to retrieve layers of interest from the individual profiles of the original profile set.
}
\examples{
## Not yet included; create avgProfile example object first.

}
\author{
fherla
}
