% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/snowprofilePro.R
\name{snowprofilePro}
\alias{snowprofilePro}
\title{Construct snowprofile object from PRO file}
\usage{
snowprofilePro(Filename, ProfileDate = NA, tz = "UTC")
}
\arguments{
\item{Filename}{path to pro file}

\item{ProfileDate}{read a single profile from file (default = NA will read all profiles)}

\item{tz}{time zone (default = 'UTC')}
}
\value{
a single snowprofile object of list of multiple snowprofile objects
}
\description{
Read .pro files from SNOWPACK model output
}
\details{
Several SNOWPACK model output formats exist see \href{https://models.slf.ch/docserver/snowpack/html/snowpackio.html}{SNOWPACK documentation}

Definitions of PRO files are provided at \href{https://models.slf.ch/docserver/snowpack/html/pro_format.html}{https://models.slf.ch/docserver/snowpack/html/pro_format.html} and an example file is available at \href{https://run.niviz.org/?file=resources\%2Fexample.pro}{niViz}

PRO files typically contain profiles from the same station at multiple time steps. If a specific \code{ProfileDate} is provided a single snowprofile object is returned (search available dates with \code{scanProfileDates}), otherwise all profiles are read and a list of snowprofile objects is returned.
}
\examples{

## Path to example pro file
Filename <- system.file('extdata', 'example.pro', package = 'sarp.snowprofile')

## Download example pro file from niViz
#Filename <- tempfile(fileext = '.pro')
#download.file('https://niviz.org/resources/example.pro', Filename)

## Scan dates in file
Dates <- scanProfileDates(Filename)
print(Dates)

## Read a single profile by date and plot
ProfileDate <- Dates[3]
Profile <- snowprofilePro(Filename, ProfileDate = ProfileDate)
plot(Profile)

## Read entire time series and plot
Profiles <- snowprofilePro(Filename)
plot(Profiles, main = 'Timeseries read from example.pro')

}
\seealso{
\link{snowprofilePrf}, \link{scanProfileDates}, \link{snowprofileSno}
}
\author{
shorton
}
