% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/satdad_Rfunctions.R
\name{gen.ds}
\alias{gen.ds}
\title{Generate a Mevlog tail dependence structure.}
\usage{
gen.ds(d, type = "alog", sub = NULL, dep = NULL, asy = NULL, mnns = d)
}
\arguments{
\item{d}{The dimension.}

\item{type}{The type of the model; represented by a character string.  This is similar to the  option \code{model} of \code{\link[evd]{rmvevd}}. It must be either \code{"log"} or \code{"alog"}  (the default), for the symmetric logistic and the asymmetric logistic model respectively.}

\item{sub}{An optional list of subsets of \eqn{\{1,...,d\}} involved in the tail dependence structure. If \code{type = "log"}, then \code{sub} should be given by \eqn{(1,\ldots,d)}, which is the way the code \code{NULL} will be interpreted. If \code{type = "alog"} and \code{sub = NULL} then  a random  list of vectors,  subsets of  \eqn{\{1,...,d\}}, is created. The cardinality of non singleton subsets in \code{sub} is given by \code{mnns}.  If the user provides \code{sub}, it has to be a list of vectors,  subsets of \eqn{\{1,...,d\}}, where each component from \eqn{\{1,...,d\}} appears at least once; Otherwise, one should add the missing singleton(s).}

\item{dep}{An optional vector of dependence parameter(s). If \code{type = "log"}, \code{dep} should be a single value. Otherwise, if \code{type = "alog"} and if the list \code{sub} is provided, then the length of the vector \code{dep} should be equal to that of the list \code{sub} (or a single value that will be replicated the length of \code{sub} times). Among these values, the dependence parameters associated singletons have to be equal to one. Otherwise, the values of \code{dep} associated to singleton will be ignored (and set to one).  When  \code{dep = NULL} its values are randomly generated.}

\item{asy}{An optional list of asymmetric weights. If \code{type = "log"}, then \code{asy} should be the vector \eqn{(1,\ldots,1)}, which is the way the code \code{NULL} will be interpreted. If \code{type = "alog"} and if \code{sub} is provided, the length of the list \code{asy} should be in accordance with the length of \code{sub}.   If \code{asy = NULL} then the values are randomly generated. Note that \code{asy} satisfies the sum-to-one constraints.}

\item{mnns}{The default value is arbitrarily equal to \eqn{d}. When \code{sub = NULL}, the list \code{sub} is randomly generated, and its size is closely related to \code{mnns}. The latter represents the number of non singletons subsets included in \code{sub}.}
}
\value{
\code{gen.ds} returns an object representing a tail dependence structure for Mevlog models.
Such object is a list containing  the following components:
 \itemize{
 \item{\code{d}} The dimension.

 \item{\code{type}} The type of the model either \code{"log"} or \code{"alog"}.

 \item{\code{sub}} The list of subsets of \eqn{\{1,...,d\}} involved in the tail dependence support.

 \item{\code{dep}}  The vector of dependence parameter(s).

 \item{\code{asy}} The list of asymmetric weights.
}
}
\description{
The function \code{gen.ds} creates (possibly randomly) a tail dependence structure for a multivariate extreme value logistic (Mevlog) model.
}
\details{
A multivariate extreme value logistic (Mevlog) model is symmetric or asymmetric.
   \itemize{
 \item{\code{type = "log". }} {It generates a multivariate symmetric logistic model. Such model is a well-known generalization of the bivariate extreme value logistic model introduced by Gumbel (1960). The parameter `dep`  (with \eqn{0 < `dep` \leq 1}) is the only parameter needed to write the following equation
\deqn{\ell(u) = ( \sum_{i=1}^d u_i^{1/\code{dep}} )^{\code{dep}}.}
 If the parameter \code{dep} is missing, the function \code{gen.ds}  will randomly generate its value from a standard uniform distribution.
 The list \code{asy} is reduced to a vector of ones whereas the list \code{sub} only contains the maximal vector \eqn{(1, \ldots, d)}.

This is a special case of the multivariate asymmetric logistic model (\code{alog} case).}

\item{\code{type = "alog". }}{It generates a  multivariate asymmetric logistic model, which has been first introduced by Tawn (1990). We have
  \deqn{\ell(u)=\sum_{b\in B}  (\sum_{i \in b} (\beta_{i,b}u_i)^{1/\alpha_b})^{\alpha_b}}
  where \eqn{B} is the power set of \eqn{\{1,...,d\}} (or a strict subset of the power set), the dependence parameters \eqn{\alpha_b} lie in \eqn{(0,1]} and the collection of asymmetric weights \eqn{\beta_{i,b}} are coefficients from [0,1] satisfying \eqn{\forall i \in \{1,\ldots,d\}, \sum_{b\in B: i \in b} \beta_{i,b}=1}.
  Missing asymmetric weights \eqn{\beta_{i,b}} are assumed to be zero. }

  }

The function \code{gen.ds}  generates here an object of class \code{ds} which corresponds in this package to the stable tail dependence function \eqn{\ell}. The class \code{ds} consists of:

  \itemize{
  \item{the dimension \code{d}.}
  \item{the type \code{"log"} or \code{alog}.}
    \item{the list \code{sub} that corresponds to \eqn{B}.
    When \code{sub} is provided, the same list of subsets is returned, eventually sorted. When \code{sub = NULL} then \code{sub} is a list of subsets of the power set of \eqn{\{1,...,d\}}. When the option \code{mnns} is used, the latter integer indicates the cardinality of non singleton subsets in \eqn{B}.
   \item{the dependence parameter \code{dep} or the vector of dependence parameters \code{dep}. When missing, these coefficients are obtained from independent standard uniform sampling.
   }
   \item{the list \code{asy} of asymmetric weights \eqn{\beta_{i,b}} for \eqn{b \in B}  and \eqn{i \in b}. When missing, these coefficients are obtained from independent standard uniform sampling followed by renormalization in order to satisfy the sum-to-one constraints.}
   }
}
}
\note{
The first interest of the \code{gen.ds} function is to generate randomly a tail dependence structure. Since \code{sub} and \code{asy} become quickly very large lists as \eqn{d} increases, it is very convenient to obtain automatically well-defined tail dependence structures for  multivariate extreme value logistic models.

The second interest of the \code{gen.ds} function is to produce partial models where all subsets do not necessarily contribute to the tail dependence support.

The function \code{gen.ds} does not manage margins characteristics which will be handle by the option \code{mar} in the  \code{r-d-p-Mevlog} functions.
}
\examples{

## Fix a 5-dimensional symmetric tail dependence structure
## The dependence paramater is fixed to .7
(ds5 <- gen.ds(d = 5, dep = .7, type = "log"))

## Fix a 3-dimensional asymmetric tail dependence structure
## The list sub and asy are provided ; The vector dep is randomly generated
(ds3 <- gen.ds(d = 3, sub = list(c(1,2), c(1,2,3)), asy = list(c(0.4,0.6), c(0.6,0.4,1))))
graphs(ds = ds3)

## Fix a 8-dimensional asymmetric tail dependence structure
## The lists sub and asy, as the vector dep, are randomly generated
(ds8 <- gen.ds(d = 8))
graphs(ds = ds8)

}
\references{
Gumbel, E. J. (1960)
Distributions des valeurs extremes en plusieurs dimensions.
\emph{Publ. Inst. Statist. Univ. Paris}, \bold{9}, 171--173.

Stephenson, A. (2002)
evd: Extreme Value Distributions.
\emph{R News}, 2(2):31--32.

Tawn, J. A. (1990)
Modelling multivariate extreme value distributions.
\emph{Biometrika}, \bold{77}, 245--253.
}
\seealso{
\code{\link[satdad]{ellMevlog}}, \code{\link[satdad]{graphs}}
}
\author{
Cécile Mercadier (\code{mercadier@math.univ-lyon1.fr})
}
