% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sazed.R
\name{ze}
\alias{ze}
\title{Compute the ZE component of the SAZED ensemble}
\usage{
ze(y, preprocess = T)
}
\arguments{
\item{y}{The input time series.}

\item{preprocess}{If true, y is detrended and z-normalized before
computation.}
}
\value{
The ZE season length estimate of y.
}
\description{
\code{ze} estimates the season length of its argument from the mean zero distance
}
\examples{
season_length <- 26
y <- sin(1:400*2*pi/season_length)
ze(y)
ze(y, preprocess = FALSE)
}
