% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample.R
\name{sampleSimpleSBM}
\alias{sampleSimpleSBM}
\title{Sampling of Simple SBMs}
\usage{
sampleSimpleSBM(
  nbNodes,
  blockProp,
  connectParam,
  model = "bernoulli",
  directed = FALSE,
  dimLabels = list(row = "rowLabel", col = "colLabels"),
  covariates = list(),
  covariatesParam = numeric(0)
)
}
\arguments{
\item{nbNodes}{number of nodes in the network}

\item{blockProp}{parameters for block proportions}

\item{connectParam}{list of parameters for connectivity with a matrix of means 'mean' and an optional matrix of variances 'var', the sizes of which must match \code{blockProp} length}

\item{model}{character describing the model for the relation between nodes (\code{'bernoulli'}, \code{'poisson'}, \code{'gaussian'}, ...). Default is \code{'bernoulli'}.}

\item{directed}{logical, directed network or not. Default is \code{FALSE}.}

\item{dimLabels}{an optional list of labels for each dimension (in row, in column)}

\item{covariates}{a list of matrices with same dimension as mat describing covariates at the edge level. No covariate per Default.}

\item{covariatesParam}{optional vector of covariates effect. A zero length numeric vector by default.}
}
\value{
an object with class \code{\link{SimpleSBM_sampler}}
}
\description{
This function samples a simple Stochastic Block Models, with various model
for the distribution of the edges:  Bernoulli, Poisson, or Gaussian models, and possibly with covariates
}
\examples{
### =======================================
### SIMPLE BINARY SBM (Bernoulli model)
## Graph parameters
nbNodes  <- 90
blockProp <- c(.5, .25, .25) # group proportions
means <- diag(.4, 3) + 0.05  # connectivity matrix: affiliation network
# In Bernoulli SBM, parameters is a list with a
# matrix of means 'mean' which are probabilities of connection
connectParam <- list(mean = means)

## Graph Sampling
mySampler <- sampleSimpleSBM(nbNodes, blockProp, connectParam, model = 'bernoulli')
plot(mySampler)
mySampler$rMemberships() # sample new memberships
mySampler$rAdjacency()   # sample new adjacency matrix
plot(mySampler)
hist(mySampler$netMatrix)

### =======================================
### SIMPLE POISSON SBM
## Graph parameters
nbNodes  <- 90
blockProp <- c(.5, .25, .25) # group proportions
means <- diag(15., 3) + 5    # connectivity matrix: affiliation network
# In Poisson SBM, parameters is a list with
# a matrix of means 'mean' which are a mean integer value taken by edges
connectParam <- list(mean = means)

## Graph Sampling
mySampler <- sampleSimpleSBM(nbNodes, blockProp, list(mean = means), model = "poisson")
plot(mySampler)
hist(mySampler$netMatrix)

### =======================================
### SIMPLE GAUSSIAN SBM
## Graph parameters
nbNodes  <- 90
blockProp <- c(.5, .25, .25)      # group proportions
means <- diag(15., 3) + 5 # connectivity matrix: affiliation network
# In Gaussian SBM, parameters is a list with
# a matrix of means 'mean' and a matrix of variances 'var'
connectParam <- list(mean = means, var = 2)

## Graph Sampling
mySampler <- sampleSimpleSBM(nbNodes, blockProp, connectParam, model = "gaussian")
plot(mySampler)
hist(mySampler$netMatrix)
}
