% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sbpiper_plots.r
\name{scatterplot_w_colour}
\alias{scatterplot_w_colour}
\title{Plot a scatter plot using a coloured palette}
\usage{
scatterplot_w_colour(df, g = ggplot(), colNameX = "x", colNameY = "y",
  colNameColor = "colour", dot_size = 1,
  colours = colorRamps::matlab.like(256), limits = NULL)
}
\arguments{
\item{df}{a data frame}

\item{g}{the current ggplot to overlap}

\item{colNameX}{the name of the column for the X axis}

\item{colNameY}{the name of the column for the Y axis}

\item{colNameColor}{the name of the column whose values are used as 3rd dimension}

\item{dot_size}{the size of the dots in the scatterplot}

\item{colours}{the palette to use}

\item{limits}{the limits for the palette (NULL if no limit is used)}
}
\value{
the plot
}
\description{
Plot a scatter plot using a coloured palette
}
\examples{
df <- data.frame(a=rnorm(10000), b=rnorm(10000), c=rev(seq(10000)))
scatterplot_w_colour(df, colNameX="a", colNameY="b", colNameColor="c")
}
