% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query_sb_date.R
\name{query_sb_date}
\alias{query_sb_date}
\title{Query SB for items within a date range}
\usage{
query_sb_date(
  start = as.POSIXct("1970-01-01"),
  end = Sys.time(),
  date_type = "lastUpdated",
  ...,
  limit = 20,
  session = current_session()
)
}
\arguments{
\item{start}{Start date as \code{\link{POSIXct}} object. Defaults to 1970-01-01}

\item{end}{End date as \code{\link{POSIXct}} object. Defaults to today.}

\item{date_type}{Which object timestamp to query against. Options are (case sensitive): 
'Acquisition', 'Award', 'Collected', 'dateCreated', 'Received', 'Reported', 
'Transmitted', 'Due', 'End', 'Info', 'lastUpdated', 'Publication', 'Release', 
'Repository Created', 'Repository Updated', 'Start'.}

\item{...}{Additional parameters are passed on to \code{\link[httr]{GET}}}

\item{limit}{Maximum number of returned items. Will do paging to retrieve
results when limit is over 1000. Use with caution, queries 10k results
are slow.}

\item{session}{Session object from \code{\link{authenticate_sb}}}
}
\description{
Queries ScienceBase for items with timestamps within a certain date/time range.
}
\examples{
\dontrun{
# find items updated today
query_sb_date(Sys.time(), Sys.time())

# find items with publications from the 1970's
query_sb_date(as.POSIXct('1970-01-01'), as.POSIXct('1980-01-01'), 
  date_type='Publication', limit=1000)

}

}
