% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scAnnotate.R
\name{scAnnotate}
\alias{scAnnotate}
\title{scAnnotate}
\usage{
scAnnotate(
  train,
  test,
  distribution = c("normal", "dep"),
  correction = c("auto", "harmony", "seurat"),
  screening = c("wilcox", "t.test"),
  threshold = 0
)
}
\arguments{
\item{train}{A data frame of cell type label in the first column and a gene expression matrix where each row is a cell and each column is a gene from training data}

\item{test}{A data matrix where each row is a cell and each column is a gene from test data}

\item{distribution}{A character string indicate the distribution assumption on positive gene expression, should be one of "normal"(default), or "dep"}

\item{correction}{A character string indicate the batch effect removal, should be one of "auto"(default), "seurat", or "harmony". "auto" will automatically select the batch effect removal follow our suggestion  using Seurat for big data (all cell population sample size greater than 100 except one cell population less than 100  and greater than 20) and using harmony for small data.}

\item{screening}{A character string indicate the gene screening methods, should be one of "wilcox"(default) or "t.test" .}

\item{threshold}{A numeric number indicate the threshold used for probabilities to classify cells into classes,should be number from "0"(default) to "1". If there's no probability higher than the threshold associated to a cell type, the cell will be labeled as "unassigned"}
}
\value{
A vector contain annotate cell type labels for test data
}
\description{
Annotate cell type labels of test data using a trained mixture model from training data
}
\examples{
data(pbmc1)
data(pbmc2)
predict_label=scAnnotate(train=pbmc1,
                         test=pbmc2[,-1],
                         distribution="normal",
                         correction ="harmony",
                         screening ="wilcox",
                         threshold=0)
}
