% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Read_&_Write_Data.R
\name{Read_CellBender_h5_Multi_Directory}
\alias{Read_CellBender_h5_Multi_Directory}
\title{Load CellBender h5 matrices (corrected) from multiple directories}
\usage{
Read_CellBender_h5_Multi_Directory(
  base_path,
  secondary_path = NULL,
  filtered_h5 = TRUE,
  custom_name = NULL,
  sample_list = NULL,
  sample_names = NULL,
  replace_suffix = FALSE,
  new_suffix_list = NULL,
  parallel = FALSE,
  num_cores = NULL,
  merge = FALSE,
  ...
)
}
\arguments{
\item{base_path}{path to the parent directory which contains all of the subdirectories of interest.}

\item{secondary_path}{path from the parent directory to count matrix files for each sample.}

\item{filtered_h5}{logical (default TRUE).  Will set the shared file name suffix \code{custom_name} is NULL.}

\item{custom_name}{if file name was customized in CellBender then this parameter should contain the portion
of file name that is shared across all samples.  Must included the ".h5" extension as well.}

\item{sample_list}{a vector of sample directory names if only specific samples are desired.  If \code{NULL} will
read in subdirectories in parent directory.}

\item{sample_names}{a set of sample names to use for each sample entry in returned list.  If \code{NULL} will
set names to the subdirectory name of each sample.}

\item{replace_suffix}{logical (default FALSE).  Whether or not to replace the barcode suffixes of matrices
using \code{\link{Replace_Suffix}}.}

\item{new_suffix_list}{a vector of new suffixes to replace existing suffixes if \code{replace_suffix = TRUE}.
See \code{\link{Replace_Suffix}} for more information.  To remove all suffixes set \code{new_suffix_list = ""}.}

\item{parallel}{logical (default FALSE) whether or not to use multi core processing to read in matrices.}

\item{num_cores}{how many cores to use for parallel processing.}

\item{merge}{logical (default FALSE) whether or not to merge samples into a single matrix or return
list of matrices.  If TRUE each sample entry in list will have cell barcode prefix added.  The prefix
will be taken from \code{sample_names}.}

\item{...}{Extra parameters passed to \code{\link[scCustomize]{Read_CellBender_h5_Mat}}.}
}
\value{
list of sparse matrices
}
\description{
Extract sparse matrix with corrected counts from CellBender h5 output file across multiple sample
subdirectories.
}
\examples{
\dontrun{
base_path <- 'path/to/data/directory'
mat_list <- Read_CellBender_h5_Multi_Directory(base_path = base_path)
}

}
\concept{read_&_write}
