\name{Predict.matrix.mpi.smooth}
%\Rdversion{1.0}
\alias{Predict.matrix.mpi.smooth}
\alias{Predict.matrix.mpd.smooth}
\alias{Predict.matrix.cx.smooth}
\alias{Predict.matrix.cv.smooth}
\alias{Predict.matrix.micx.smooth}
\alias{Predict.matrix.micv.smooth}
\alias{Predict.matrix.mdcx.smooth}
\alias{Predict.matrix.mdcv.smooth}
\alias{Predict.matrix.tedmd.smooth}
\alias{Predict.matrix.tedmi.smooth}
\alias{Predict.matrix.tesmd1.smooth}
\alias{Predict.matrix.tesmd2.smooth}
\alias{Predict.matrix.tesmi1.smooth}
\alias{Predict.matrix.tesmi2.smooth}

\title{Predict matrix method functions for SCAMs
}
\description{The various built in smooth classes for use with \code{\link{scam}} have associate 
       \code{\link{Predict.matrix}} method functions to enable prediction from the fitted model. }

\usage{
\method{Predict.matrix}{mpi.smooth}(object, data)
\method{Predict.matrix}{mpd.smooth}(object, data)
\method{Predict.matrix}{cv.smooth}(object, data)
\method{Predict.matrix}{cx.smooth}(object, data)
\method{Predict.matrix}{micx.smooth}(object, data)
\method{Predict.matrix}{micv.smooth}(object, data)
\method{Predict.matrix}{mdcx.smooth}(object, data)
\method{Predict.matrix}{mdcv.smooth}(object, data)
\method{Predict.matrix}{tedmd.smooth}(object, data)
\method{Predict.matrix}{tedmi.smooth}(object, data)
\method{Predict.matrix}{tesmd1.smooth}(object, data)
\method{Predict.matrix}{tesmd2.smooth}(object, data)
\method{Predict.matrix}{tesmi1.smooth}(object, data)
\method{Predict.matrix}{tesmi2.smooth}(object, data)

}

\arguments{
 \item{object}{A smooth object, usually generated by a \code{smooth.construct} method having 
processed a smooth specification object generated by an \code{s} term in a 
\code{\link{scam}} formula.}

\item{data}{A data frame containing the values of the named covariates at which the smooth term is to be 
    evaluated.}

}
\value{A matrix mapping the coefficients for the smooth term to its values at the supplied data values. 
}
\references{
   Pya, N. and Wood, S.N. (2014) Shape constrained additive models. Statistics and Computing, DOI \url{http://dx.doi.org/10.1007/s11222-013-9448-7}

Pya, N. (2010) Additive models with shape constraints. PhD thesis. University of Bath. Department of Mathematical Sciences

   Wood S.N. (2006) Generalized Additive Models: An Introduction with R. Chapman and Hall/CRC Press.

}
\author{
Natalya Pya <nat.pya@gmail.com>

}

\keyword{models} \keyword{regression}%-- one or more ..
