\name{smooth.construct.mifo.smooth.spec}
%\Rdversion{1.2-9}
\alias{smooth.construct.mifo.smooth.spec}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Constructor for monotone increasing SCOP-splines with an additional 'finish at zero' constraint
}
\description{This is a special method function
  for creating smooths subject to a monotone increasing constraint plus the smooths should pass through zero at the right-end point of the covariate range. This is similar to the \code{pc} argument to  \code{s} in  \code{mgcv(gam)} when \code{pc=max(x)}, where \code{x} is a covariate.
 The smooth is built by the \code{mgcv} constructor function for smooth terms, \code{smooth.construct}. 'Zero intercept' identifiability constraints used for univariate SCOP-splines are substituted with a 'finish at zero' constraint here. This smooth is specified via model terms such as 
  \code{s(x,k,bs="mifo",m=2)}, 
  where \code{k} denotes the basis dimension and \code{m+1} is the order of the B-spline basis.
}
\usage{
\method{smooth.construct}{mifo.smooth.spec}(object, data, knots)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{object}{A smooth specification object, generated by an \code{s} term in a GAM formula.} 

  \item{data}{A data frame or list containing the data required by this term,
     with names given by \code{object$term}. The \code{by} variable is the last element.}
 
  \item{knots}{An optional list containing the knots supplied for basis setup.  
          If it is \code{NULL} then the knot locations are generated automatically.}

}
\details{
  The constructor is not called directly, but as with \code{gam(mgcv)} is used internally. 

A 'finish at zero' constraint is achieved by setting the last (m+1) spline coefficients to zero. According to the B-spline basis functions properties, the value of the spline, \code{f(x)}, is determined by \code{m+2} non-zero basis functions, and only \code{m+1} B-splines are non-zero at knots. Only \code{m+2} B-splines are non-zero on any \code{[k_i, k_{i+1})}, and the sum of these \code{m+2} basis functions is 1.

If the knots of the spline are not supplied, then they are placed evenly throughout the covariate values with an exception of the \code{m} inner knots preceeding the last inner knot that are joined with that last knot. This is done in order to avoid an otherwise plateau fit at the right-end region. If the knots are supplied, then the number of supplied knots should be \code{k+m+2}, and the range of the middle \code{k-m} knots must include all the covariate values.

Note: when a plateau region is expected at the righ-end covariate region, the smooth might result in some decrease when approaching to zero.  

}
\value{ An object of class \code{"mifo.smooth"}. 
}
\references{
Pya, N. and Wood, S.N. (2015) Shape constrained additive models. Statistics and Computing, 25(3), 543-559

Pya, N. (2010) Additive models with shape constraints. PhD thesis. University of Bath. Department of Mathematical Sciences

}
\author{ 
   Natalya Pya <nat.pya@gmail.com>

}
%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
\code{\link{smooth.construct.mpi.smooth.spec}},
\code{\link{smooth.construct.miso.smooth.spec}},

\code{\link{smooth.construct.mpd.smooth.spec}},
 \code{\link{smooth.construct.mdcv.smooth.spec}}, 

\code{\link{smooth.construct.mdcx.smooth.spec}}, \code{\link{smooth.construct.micv.smooth.spec}}, 

\code{\link{smooth.construct.micx.smooth.spec}}

}
\examples{
 
  ## Monotone increasing SCOP-spline examples with a finish at zero constraint...
  set.seed(53)
  n <- 100;x <- runif(n);z <- runif(n)
  pc <- max(x)
  y <- exp(3*x)/10-exp(3*pc)/10 + z*(1-z)*5 + rnorm(100)*.4
  m1 <- scam(y~s(x,bs='mifo')+s(z)) #,knots=knots) 
  plot(m1,pages=1,scale=0)
  summary(m1)
  newd<- data.frame(x=pc,z=0)
  predict(m1,newd, type='terms')


}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{models} \keyword{regression}%-- one or more ..




