% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fill_missing.R
\name{fill_missing}
\alias{fill_missing}
\title{Replacing missing measurement times in single-case data}
\usage{
fill_missing(data, dvar, mvar, na.rm = TRUE)
}
\arguments{
\item{data}{A single-case data frame. See \code{\link{scdf}} to learn about
this format.}

\item{dvar}{Character string with the name of the dependent variable.
Defaults to the attributes in the scdf file.}

\item{mvar}{Character string with the name of the measurement time variable.
Defaults to the attributes in the scdf file.}

\item{na.rm}{If set \code{TRUE}, \code{NA} values are also interpolated.
Default is \code{na.rm = TRUE}.}
}
\value{
A single-case data frame with interpolated missing data
  points.  See \code{\link{scdf}} to learn about the SCDF Format.
}
\description{
The \code{fillmissingSC} function replaces missing measurements in
single-case data.
}
\details{
This procedure is recommended if there are gaps between measurement times
(e.g. MT: 1, 2, 3, 4, 5, ... 8, 9) or explicitly missing values in your
single-case data and you want to calculate overlap indices
(\code{\link{overlapSC}}) or a randomization test (\code{\link{randSC}}).
}
\examples{

## In his study, Grosche (2011) could not realize measurements each single week for
## all participants. During the course of 100 weeks, about 20 measurements per person
## at different times were administered.

## Fill missing values in a single-case dataset with discontinuous measurement times
Grosche2011filled <- fill_missing(Grosche2011)
study <- c(Grosche2011[2], Grosche2011filled[2])
names(study) <- c("Original", "Filled")
plot(study)

## Fill missing values in a single-case dataset that are NA
Maggie <- random_scdf(design(level = list(0,1)), seed = 123)
Maggie_n <- Maggie
replace.positions <- c(10,16,18)
Maggie_n[[1]][replace.positions,"values"] <- NA
Maggie_f <- fill_missing(Maggie_n)
study <- c(Maggie, Maggie_n, Maggie_f)
names(study) <- c("original", "missing", "interpolated")
plot(study, marks = list(positions = replace.positions), style = "grid2")

}
\seealso{
Other data manipulation functions: 
\code{\link{add_l2}()},
\code{\link{as.data.frame.scdf}()},
\code{\link{as_scdf}()},
\code{\link{moving_median}()},
\code{\link{outlier}()},
\code{\link{ranks}()},
\code{\link{scdf}},
\code{\link{select_cases}()},
\code{\link{set_vars}()},
\code{\link{shift}()},
\code{\link{smooth_cases}()},
\code{\link{standardize}()},
\code{\link{truncate_phase}()}
}
\author{
Juergen Wilbert
}
\concept{data manipulation functions}
\keyword{manip}
